/*!
 * \file       dia_ResponsePendingHandler.h
 *
 * \brief      Handling of Response-Pending as Message-Handler of udd-comm-channel
 *
 * \details    
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreUDD
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_RESPONSE_PENDING_HANDLER__
#define __INCLUDED_DIA_RESPONSE_PENDING_HANDLER__


#include <unistd.h>
#include <netdb.h>
#include <sys/socket.h>





#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SELF_TIMER__
#include "common/framework/application/dia_SelfTimer.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DIAGNOSIS_RESPONSE_LISTENER__
#include <common/interfaces/dia_IDiagnosisResponseListener.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif


#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif


namespace dia {


class ResponsePendingHandler :
      public dia_MessageHandler,
      public IDiagnosisResponseListener,
      public dia_ISessionListenerImpl

{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(ResponsePendingHandler) ;
public:
   struct MsgTimeoutP2 {
   };

   //! class TesterPresentHandler
   ResponsePendingHandler ( );
   //! class constructor with next hanndler passed
   ResponsePendingHandler (dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~ResponsePendingHandler ( void );

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );



   //! method called on timeout
   void onTimeout(MsgTimeoutP2 *msg);

   //! overloaded method from class IDiagnosisResponseListener
   virtual tVoid onDiagnosisResponse ( tU8 const *au8MsgBuffer, tU16 u16Length );

   //! overloaded method from dia_ISessionListener
   // 
   virtual tVoid vOnSessionChanged ( tU8 newSession, tU8 oldSession );



protected:
   //! setup method for the application
   virtual tDiaResult setup ( void );
   //! shutdown method for the application
   virtual tDiaResult tearDown ( void );

private:
   class PendingResponse {
   public:
      PendingResponse():
         mSid(0),
         mSubFn(0),
         mFuncResponseSend(nullptr),
         mCookie(0),
         mNumEmit(0)
      {}

      bool isActive() {
         return mSid && mFuncResponseSend;
      }

      bool set(dia_MessageBuffer& msg, tCookieType cookie = 0);

      void reset();

      void emit();

      uint8_t getSid() {
         return mSid;
      }

      bool hasSuppressPositiveResponse();

   private:
      uint8_t mSid;
      uint8_t mSubFn;
      dia_MessageBuffer::tFuncSendResponse mFuncResponseSend;
      tCookieType mCookie;
      uint32_t mNumEmit;

      static const uint32_t mMaxNumEmit=20;
   };
   
   //! store if setup() has already run.
   bool mIsSetupDone;

   //! timeout to (re-)transmit nack response-pending
   tU32 mP2FirstValMs;
   tU32 mP2ValMs;

   PendingResponse mPendingResponse;

   RefCounter mRefCounter;
   SelfTimer<ResponsePendingHandler, MsgTimeoutP2> mP2Timer;

      /* needed input. 

         - check all reqest and forward them
         -- check if request needs response (e.g. tester-present)
         -- if response needed, start timer, set pending-flag

         - check output
         -- if response if contained (ack or nack): stop timer, reset pending-flag

         - timeout:
         -- ignore if not pending-flag
         -- send response pending (is there a max time to give up???)
         -- restart timer
         
         - close of channel
         - stop timer, reset pending-flag
      */
};





}

#endif

