/*
 * dia_MessageBufferUDS.h
 *
 *  Created on: 14.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#define __INCLUDED_DIA_MESSAGE_BUFFER_UDS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#include "common/framework/engine/dia_MessageBuffer.h"
#endif

class dia_Engine;

class dia_MessageBufferUDS
    : public dia_MessageBuffer
{
public:
   dia_MessageBufferUDS (
         const tU8 byteBuffer[],
         tU16 length,
         tFuncSendResponse funcResponseSend,
         enBufferState enState = holds_request,
         enBufferFormat enFormat = format_length_and_data,
         tCookieType cookie = 0
   );

   dia_MessageBufferUDS (
         const std::vector<tU8>& byteBuffer,
         tFuncSendResponse funcResponseSend,
         enBufferState enState = holds_request,
         enBufferFormat enFormat = format_length_and_data,
         tCookieType cookie = 0
   );

   virtual ~dia_MessageBufferUDS ( void );

   // Prototypes for Message responses
   virtual void vSetNegResp ( tU8 u8NegRespCode );
   virtual void vSetPosResp ( void );

   // Function Prototypes for extraction of service id and sub service id
   virtual tU16 u16GetServiceId ( void ) const;

   // The UDS Service Id is one byte - so u16GetServiceId is wrong? Tidy later.
   virtual  tU8 u8GetServiceId ( void ) const;

   virtual tU16 u16GetSubServiceId() const;
   virtual tU8  u8GetSubServiceId() const;

protected:
   //! deprecated default constructor without implementation
   dia_MessageBufferUDS ( void );

   // Some useful constants
   static const tU8 udsPosRespMask = 0x40;  // UdsPosResponseMask
};

#endif /* __INCLUDED_DIA_MESSAGE_BUFFER_UDS__ */
