/*
 * dia_LastDiagErrorHandler.cpp
 *
 *  Created on: 22.07.2015
 *      Author: maj9kor
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include <common/framework/protocols/uds/dia_MessageBufferUDS.h>
#endif

#ifndef DIA_LASTDIAGERRORHANDLER_H_
#include <common/framework/protocols/uds/dia_LastDiagErrorHandler.h>
#endif

using namespace dia;
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------

dia_LastDiagErrorHandler::dia_LastDiagErrorHandler ( void )
{
   dia_tclFnctTrace trc("dia_LastDiagErrorHandler::dia_LastDiagErrorHandler");

}

//-----------------------------------------------------------------------------

dia_LastDiagErrorHandler::~dia_LastDiagErrorHandler ( void )
{

}

//-----------------------------------------------------------------------------

tDiaResult
dia_LastDiagErrorHandler::handleMessage ( dia_MessageBuffer& msg )
{
   dia_tclFnctTrace trc("dia::LastDiagErrorHandler::handleMessage(dia_MessageBuffer&)");

     if ( msg.getProtocol() == DIA_EN_PROTOCOL_UDS )
     {
  	   bool needToResetLastDebugError = true;

        tU16 offset = (msg.getFormat() == dia_MessageBuffer::format_length_and_data) ? 2 : 1; /* one length byte plus one byte SID */
        if ( msg.getDataU8(tU16(offset-1)) == DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER )
        {
	      tU16 did =  tU16(msg.getDataU8(offset) << 8);
	      did = tU16(did | msg.getDataU8(++offset));
	      if ( did == DIA_C_U16_DID_LAST_DIAG_ERROR )
      	  {
      		  needToResetLastDebugError= false;
      	  }
        }
        if ( msg.getDataU8(tU16(offset-1)) == DIA_C_U8_UDS_SID_SESSION_CONTROL )
        {
      	  needToResetLastDebugError= false;
        }

        if ( needToResetLastDebugError )
        {
	       size_t length = strlen(lastdiagerror);
	       if ( dia_setProperty(DIA_PROP_CM_CONFIG_LAST_DIAG_ERROR, (tU8*) lastdiagerror, (tU16) length) == DIA_SUCCESS )
	       {
	        DIA_TR_INF("Successfully set lastdiagerror to default");
           }
        }
     }

     return dia_MessageHandler::handleMessage(msg);
}


