/*!
 * \file       dia::ALDStatusHandler.h
 *
 * \brief      Pre-service handler for all diag production services
 *             (check if ALD status is unknown when the device is in production session)
 *
 * \details    If ALD level is unknown, wait until ALD sends the status.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaServicesProject
 *
 * \copyright  (c) 2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */


#ifndef __INCLUDED_DIA_ALDSTATUS_HANDLER__
#define __INCLUDED_DIA_ALDSTATUS_HANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#include <common/framework/engine/dia_MessageHandler.h>
#endif

class dia_MessageBuffer;

namespace dia {

class ALDStatusHandler
   : public dia_MessageHandler
{
public:
   //! class constructor
   ALDStatusHandler ( void );
   //! class constructor with next handler passed
   ALDStatusHandler ( dia_MessageHandler* nextHandler );
   //! class destructor
   virtual ~ALDStatusHandler ( void );
   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg );
   //! start postprocessing after all predicates of the deferred message were matched
   virtual void postprocessMessage ( dia_MessageBuffer* msg );
};

}

#endif /* __INCLUDED_DIA_ALDSTATUS_HANDLER__ */
