/**
 * \file    dia_LookupKeyGMLan.h
 *
 * \brief   This file contains the definition of the dia_LookupKeyGMLan class that is
 *          used to check if a service handler for incoming diagnosis request is
 *          available
 *
 * \author  gib2hi
 * \date    2012/04/24
 */

#ifndef __INCLUDED_DIA_LOOKUPKEYGMLAN__
#define __INCLUDED_DIA_LOOKUPKEYGMLAN__

#ifndef __INCLUDED_DIA_COMMON_ENGINE__
#include "common/framework/engine/dia_common_engine.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_PROTOCOLS_GMLAN__
#include "common/framework/protocols/gmlan/dia_common_gmlan.h"
#endif

/**
 * \class   dia_LookupKeyGMLan
 *
 * \brief   This class is used to check if a service handler for incoming diagnosis
 *          request is available
 *
 * \ingroup diaCoreEngine
 */

class dia_LookupKeyGMLan : public dia_LookupKey
{
   DECL_DEPRECATED_DEFAULT_CONSTRUCTOR(dia_LookupKeyGMLan);
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_LookupKeyGMLan);

public:
   //! class constructor that calculates a key from a received message
   dia_LookupKeyGMLan ( const dia_MessageBuffer& msgBuffer );
};

#endif /* __INCLUDED_DIA_LOOKUPKEYGMLAN__ */
