/**
 * \file      dia_OSALDrvKds.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      18.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_OSAL_DRIVER_KDS__
#define __INCLUDED_DIA_OSAL_DRIVER_KDS__

#ifndef __INCLUDED_DIA_INTERFACE_DRIVER__
#include "common/framework/platform/dia_IDriver.h"
#endif

#define DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE            ((tU32) 0x00010000)

class dia_OSALDriverKDS
   : public dia_IDriver
{
public:
   class sDataKDS
   {
   public:
      sDataKDS ( tU16 key, tU8 data[], tU16 length )
         : mKey(key), mLen(length), mpData(data)
      {}

      sDataKDS ( const sDataKDS& org )
         : mKey(org.mKey),
           mLen(org.mLen),
           mpData(org.mpData)  //lint !e1554 Warning: Direct pointer copy of member, but this struct is exclusively used locally to pass data to the driver
      {}

      ~sDataKDS ( void )
      {
         mpData = 0;
      }

      sDataKDS& operator = ( const sDataKDS& org )
      {
         if ( this != &org )
         {
            mKey = org.mKey;
            mLen = org.mLen;
            mpData = org.mpData; //lint !e1555 Warning: Direct pointer copy of member, but this struct is exclusively used locally to pass data to the driver
         }
         return *this;
      }

   protected:
      sDataKDS ( void );

   public:
      tU16 mKey;
      tU16 mLen;
      tU8* mpData;
   };

public:
   //! constructor for the driver
   dia_OSALDriverKDS ( dia_IDriver* pDriver ) : mpDriver(pDriver) {}
   //! destructor
   virtual ~dia_OSALDriverKDS ( void ) { mpDriver = 0; }

   //! open the driver
   virtual tDiaResult open ( void );
   //! close the driver
   virtual tDiaResult close ( void );
   //! native read from KDS
   virtual tS32 read ( tU8 data[], tU16 length );
   //! native read from KDS
//   virtual tS32 read ( std::vector<tU8>& data ) { return DIA_ERR_S32_DRIVER_NOT_SUPPORTED; }
   //! native write to KDS
   virtual tS32 write ( tU8 data[], tU16 length );
   //! native write to KDS
//   virtual tS32 write ( const std::vector<tU8>& data ) { return DIA_ERR_S32_DRIVER_NOT_SUPPORTED; }
   //! control behaviour of the driver
   virtual tDiaResult ioctrl ( tS32 func, intptr_t arg );
   //! native flushing of KDS
   virtual tDiaResult flush ( void );

protected:
   //! constructor for the driver
   dia_OSALDriverKDS ( void ) : mpDriver(0) {}

protected:
   //! pointer to physical driver
   dia_IDriver* mpDriver;
};

#endif /* __INCLUDED_DIA_OSAL_DRIVER_KDS__ */
