/**
 * \file      dia_OSALDrvKds.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      18.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include "dia_OSALDriverKDS.h"

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriverKDS::open ( void )
{
   return ( mpDriver ) ? mpDriver->open() : DIA_FAILED;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriverKDS::close ( void )
{
   return ( mpDriver ) ? mpDriver->close() : DIA_FAILED;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriverKDS::ioctrl ( tS32 func, intptr_t arg )
{
   return ( mpDriver ) ? mpDriver->ioctrl(func,arg) : DIA_FAILED;
}

//----------------------------------------------------------------------------------------

tS32
dia_OSALDriverKDS::write ( tU8 data[], tU16 length )
{
   dia_tclFnctTrace trc("dia_OSALDriverKDS::write(tU8[],tU16)");

   tS32 retCode = DIA_ERR_S32_DRIVER_FAILED;

   if ( !mpDriver ) return retCode;

   if ( length && (length != sizeof(sDataKDS)) )
   {
      DIA_TR_ERR("KDS Write Error (INVALID LENGTH --> Does not match expected size) !!");
      return DIA_ERR_S32_DRIVER_INVALID_LENGTH;
   }

   sDataKDS* pData = (sDataKDS*) data; //lint !e826 Info: Suspicious pointer-to-pointer conversion (area too small), but we use this struct to pass to the driver

   if ( pData->mLen > KDS_MAX_ENTRY_LENGTH )
   {
      DIA_TR_ERR("KDS Write Error (INVALID LENGTH --> null or to many bytes) !!");
      return DIA_ERR_S32_DRIVER_INVALID_LENGTH;
   }

   DIA_TR_INF("pData->mLen = %u decimal, length = %u", pData->mLen, length);

   if (open() == DIA_SUCCESS)
   {
      // Fix for MMS 220153
      tDiaResult IOCtrlRetVal;
      if (DIA_SUCCESS != (IOCtrlRetVal = ioctrl(OSAL_C_S32_IOCTRL_KDS_WRITE_ENABLE, TRUE)))
      {
         DIA_TR_ERR("Enabling KDS write mode failed! ErrCode = 0x%08X", IOCtrlRetVal);
         return DIA_ERR_S32_DRIVER_WRITE_FAILED;
      }

      if (!(pData->mLen))
      {
         if (DIA_SUCCESS != (IOCtrlRetVal = ioctrl(OSAL_C_S32_IOCTRL_KDS_INVALIDATE_ENTRY, pData->mKey)))
         {
            DIA_TR_ERR("dia_OSALDriverKDS::write - Delete KDS Entry key 0x%04x failed! ErrCode=0x%08X", pData->mKey, IOCtrlRetVal);
            retCode = DIA_ERR_S32_DRIVER_DELETE_FAILED;
         }
         else
         {
            DIA_TR_ERR("dia_OSALDriverKDS::write Item 0x%04x - deleted.", pData->mKey);
            flush();
            retCode = DIA_ERR_S32_DRIVER_SUCCESS;
         }
      }
      else
      {
         tsKDSEntry mKeyData;
         mKeyData.u16Entry = pData->mKey;
         mKeyData.u16EntryLength = pData->mLen;
         mKeyData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
         (void) ::memcpy(mKeyData.au8EntryData, pData->mpData, pData->mLen);

         retCode = mpDriver->write((tU8*) &mKeyData, sizeof(mKeyData));

         if ( retCode >= DIA_ERR_S32_DRIVER_SUCCESS )
         {
            flush();
         }
         else
         {
            DIA_TR_ERR("Writing to KDS has failed with errCode = 0x%08X !!", retCode);
            retCode = DIA_ERR_S32_DRIVER_WRITE_FAILED;
         }
      }

      // close the driver if it was opened
      close();
   }
   else
   {
      DIA_TR_ERR("Unable to Open KDS !!");
      retCode = DIA_ERR_S32_DRIVER_OPEN_FAILED;
   }

   return retCode;
}

//----------------------------------------------------------------------------------------
#define DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE            ((tU32) 0x00010000)

tS32
dia_OSALDriverKDS::read ( tU8 data[], tU16 length )
{
   dia_tclFnctTrace trc("dia_OSALDriverKDS::read(tU8[],tU16)");

   tS32 retCode = DIA_ERR_S32_DRIVER_FAILED;

   if ( length != sizeof(sDataKDS) )
   {
      DIA_TR_ERR("KDS Read Error (INVALID LENGTH --> Does not match expected size) !!");
      return DIA_ERR_S32_DRIVER_INVALID_LENGTH;
   }

   sDataKDS* pData = (sDataKDS*) data; //lint !e826 Info: Suspicious pointer-to-pointer conversion (area too small), but we use this struct to pass to the driver

   if ( pData->mLen > KDS_MAX_ENTRY_LENGTH )
   {
      DIA_TR_ERR("KDS Read Error (INVALID LENGTH --> null or to many bytes) !!");
      return DIA_ERR_S32_DRIVER_INVALID_LENGTH;
   }

   if (open() == DIA_SUCCESS)
   {
      tsKDSEntry mKeyData;
      mKeyData.u16Entry = pData->mKey;
      mKeyData.u16EntryLength = pData->mLen;
      mKeyData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
      mKeyData.au8EntryData[0] = 0; // necessary?

      tS32 s32RetCode = mpDriver->read((tU8*)&mKeyData, sizeof(mKeyData));

      switch (s32RetCode)
      {
      case sizeof(tsKDSEntry) /* OSAL_E_NOERROR */:
         {
            DIA_TR_INF("dia_OSALDriverKDS::read(tU8[],tU16) OSAL_E_NOERROR");
            // a size of zero indicates that we are requesting the current kds item size 
            if(pData->mLen == 0)
            {
               DIA_TR_INF("dia_OSALDriverKDS::read(tU8[],tU16) mKeyData.u16EntryLength = %d", mKeyData.u16EntryLength);
               pData->mLen = 1;
               pData->mpData[0] = tU8(mKeyData.u16EntryLength & 0xff);
               retCode = DIA_ERR_S32_DRIVER_SUCCESS;
            }
            else if ( mCtrlSettings & DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE )
            {
               DIA_TR_INF("dia_OSALDriverKDS::read(tU8[],tU16) mKeyData.u16EntryLength = %d", mKeyData.u16EntryLength);
               (void) ::memcpy(pData->mpData, mKeyData.au8EntryData, mKeyData.u16EntryLength);
               if ( mCtrlSettingsVolatile & DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE )
               {
                  resetCtrlSettings(DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE);
               }
               pData->mLen = mKeyData.u16EntryLength;
               retCode = DIA_ERR_S32_DRIVER_SUCCESS;
            }
            else if(pData->mLen <= mKeyData.u16EntryLength)
            {
               DIA_TR_INF("dia_OSALDriverKDS::read(tU8[],tU16) pData->mLen = %d", pData->mLen);
               (void) ::memcpy(pData->mpData, mKeyData.au8EntryData, pData->mLen);
               retCode = DIA_ERR_S32_DRIVER_SUCCESS;
            }
            else
            {
               DIA_TR_ERR("dia_OSALDriverKDS::read: requested length larger than current content");
               retCode = DIA_ERR_S32_DRIVER_INVALID_LENGTH;
            }

         }
         break;

      case OSAL_C_S32_IOCTRL_KDS_CS_ERROR:
         {
            DIA_TR_ERR("readKDS - KDS Read Error (CHECKSUM ERROR) !!");
            retCode = DIA_ERR_S32_DRIVER_CHECKSUM;
         }
         break;

      default:
         {
            DIA_TR_ERR("readKDS - KDS Read Error !! (errcode=%d)", s32RetCode);
            retCode = DIA_ERR_S32_DRIVER_READ_FAILED;
         }
         break;
      }

      close();
   }
   else
   {
      DIA_TR_ERR("readKDS - Unable to Open KDS !!");
      retCode = DIA_ERR_S32_DRIVER_OPEN_FAILED;
   }

   return retCode;
}

//-----------------------------------------------------------------------------

#ifdef __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__
#include <unistd.h>
#endif

tDiaResult
dia_OSALDriverKDS::flush ( void )
{
   tDiaResult retCode = DIA_FAILED;

   if ( !mpDriver ) return DIA_FAILED;

   if ( (!checkFlushCtrlBits(DIA_C_U16_FLUSH_CTRL_DISABLE)) && (!checkFlushCtrlBits(DIA_C_U16_FLUSH_CTRL_DISABLE_MASTER)) )
   {
      if (open() == DIA_SUCCESS)
      {
         // Fix for MMS 220153
         if (OSAL_OK != mpDriver->ioctrl(OSAL_C_S32_IOCTRL_KDS_WRITE_ENABLE, TRUE))
         {
            DIA_TR_ERR("Enabling KDS write mode failed!");
            return DIA_E_WRITE_FAILED_KDS;
         }

         if (OSAL_OK == mpDriver->ioctrl(OSAL_C_S32_IOCTRL_KDS_WRITE_BACK, 0))
         {
            retCode = DIA_SUCCESS;
#ifdef __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__
            DIA_TR_INF("###############################################");
            DIA_TR_INF("# CALLING UNIX::SYNC                          #");
            DIA_TR_INF("###############################################");
#ifndef __DIA_UNIT_TESTING__
            sync();
            OSAL_s32ThreadWait(100);
            sync();
            OSAL_s32ThreadWait(100);
#endif
#endif
         }
         else
         {
            DIA_TR_ERR("Writing KDS back to flash failed!");
         }

         // close the driver if it was opened
         close();
      }

      if ( retCode == DIA_SUCCESS )
      {
         DIA_TR_INF("KDS MASTER FLUSH SUCCEEDED");
      }
      else
      {
         DIA_TR_INF("KDS MASTER FLUSH FAILED !!!");
      }
   }
   else
   {
      if (checkFlushCtrlBits(DIA_C_U16_FLUSH_CTRL_DISABLE))          DIA_TR_INF("Flag DIA_C_U16_FLUSH_CTRL_DISABLE is set");
      if (checkFlushCtrlBits(DIA_C_U16_FLUSH_CTRL_DISABLE_MASTER))   DIA_TR_INF("Flag DIA_C_U16_FLUSH_CTRL_DISABLE_MASTER is set");

      DIA_TR_INF("FLUSHING IS DISABLED. KDS NOT WRITTEN BACK TO KDS !!!");
      retCode = DIA_E_DRIVER_FLUSH_DISABLED;
   }

   return retCode;
}

