/**
 * \file      dia_OSALDriver.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      18.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#include "dia_OSALDriver.h"

//----------------------------------------------------------------------------------------

dia_OSALDriver::dia_OSALDriver ( tCString name )
   : mDriverName(name),
     mDriverHandle(OSAL_ERROR),
     mIsOpen(false),
     mRefCounter(0)
{
   dia_tclFnctTrace trc("dia_OSALDriver::dia_OSALDriver");
}

//----------------------------------------------------------------------------------------

dia_OSALDriver::~dia_OSALDriver ( tVoid )
{
   mDriverName = 0;
}

tDiaResult
dia_OSALDriver::open ( tVoid )
{
   dia_tclFnctTrace trc("dia_OSALDriver::open");

   if ( mIsOpen ) {
      DIA_TR_INF("KDS DRIVER ALREADY OPENED !!!");
      mRefCounter++;
      return DIA_SUCCESS;
   }

   tDiaResult retCode = DIA_E_DRIVER_OPEN_FAILED;

   mDriverHandle = OSAL_IOOpen(mDriverName, OSAL_EN_READWRITE);
   if (mDriverHandle != OSAL_ERROR)
   {
      mIsOpen = true;
      mRefCounter++;
      retCode = DIA_SUCCESS;
   }

   if (retCode != DIA_SUCCESS)
   {
      DIA_TR_ERR("FAILED TO OPEN KDS DRIVER \"%s\" (%s)!!",mDriverName,const_cast<tChar*>(OSAL_coszErrorText(OSAL_u32ErrorCode())));
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriver::close ( tVoid )
{
   dia_tclFnctTrace trc("dia_OSALDriver::close");

   if ( mIsOpen )
   {
      if (  mRefCounter ) mRefCounter--;
      if ( !mRefCounter )
      {
          tS32 retCode = OSAL_s32IOClose(mDriverHandle);
          DIA_TR_INF("OSAL_s32IOClose returned 0x%08X", retCode);
          mDriverHandle = OSAL_ERROR;
          mIsOpen = false;
      }
   }

   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tS32
dia_OSALDriver::read ( tU8 data[], tU16 length )
{
   dia_tclFnctTrace trc("dia_OSALDriver::read()");

   if (OSAL_ERROR==mDriverHandle)
   {
      DIA_TR_ERR("##### dia_OSALDriver::read(): INVALID DRIVER HANDLE #####");
      return OSAL_ERROR;
   }

   return OSAL_s32IORead(mDriverHandle,(tPS8) data, length);
}

//----------------------------------------------------------------------------------------

tS32
dia_OSALDriver::write ( tU8 data[], tU16 length )
{
   dia_tclFnctTrace trc("dia_OSALDriver::write()");

   if (OSAL_ERROR == mDriverHandle)
   {
      DIA_TR_ERR("##### dia_OSALDriver::write(): INVALID DRIVER HANDLE #####");
      return OSAL_ERROR;
   }

   return OSAL_s32IOWrite(mDriverHandle,(tPCS8) data, length);
}

//------------------------------------------------------------------------------------------

tDiaResult
dia_OSALDriver::ioctrl ( tS32 func, intptr_t arg )
{
   dia_tclFnctTrace trc("dia_OSALDriver::ioctrl()");

   if ( OSAL_ERROR ==mDriverHandle)
   {
      DIA_TR_ERR("##### dia_OSALDriver::ioctrl(): INVALID DRIVER HANDLE #####");
      return DIA_E_NOT_AVAILABLE;
   }

   tS32 retVal = OSAL_s32IOControl(mDriverHandle, func, arg);
   if ( OSAL_OK != retVal )
   {
      DIA_TR_ERR("### IOCTRL FAILED FOR OSAL DRIVER \"%s\". ErrCode=%d.",mDriverName, retVal);
      return DIA_FAILED;
   }

   return DIA_SUCCESS;
}

