/**
 * \file      dia_IDriver.h
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      18.05.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */


#ifndef __INCLUDED_DIA_INTERFACE_DRIVER__
#define __INCLUDED_DIA_INTERFACE_DRIVER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

// deprecated control settings. don't extend this list of definitions. please use mCtrlSettings mask instead
#define DIA_C_U16_FLUSH_CTRL_DEFAULT_MASK                ((tU16)     0x0000)
#define DIA_C_U16_FLUSH_CTRL_DISABLE_MASTER              ((tU16)     0x0001)
#define DIA_C_U16_FLUSH_CTRL_DISABLE                     ((tU16)     0x0002)   //set this flag to avoid flush
#define DIA_C_U16_FLUSH_CTRL_MULTI_MODE                  ((tU16)     0x0004)

#define DIA_C_U32_CTRL_SETTINGS_DEFAULT_MASK             ((tU32) 0x00000000)
#define DIA_C_U32_CTRL_SETTINGS_DEFAULT_MASK_FLUSH       ((tU32) 0xFFFF0000)
#define DIA_C_U32_CTRL_SETTINGS_FLUSH_DISABLE_MASTER     ((tU32) 0x00000001)
#define DIA_C_U32_CTRL_SETTINGS_FLUSH_DISABLE            ((tU32) 0x00000002)   //set this flag to avoid flush
#define DIA_C_U32_CTRL_SETTINGS_FLUSH_MULTI_MODE         ((tU32) 0x00000004)

#define DIA_C_S32_IOCTRL_TRACE_SET_LOCK_STATUS           ((tS32) 0x00000001)

#define DIA_ERR_S32_DRIVER_SUCCESS                       ((tS32)          0)
#define DIA_ERR_S32_DRIVER_FAILED                        ((tS32)         -1)
#define DIA_ERR_S32_DRIVER_READ_FAILED                   ((tS32)         -2)
#define DIA_ERR_S32_DRIVER_WRITE_FAILED                  ((tS32)         -3)
#define DIA_ERR_S32_DRIVER_DELETE_FAILED                 ((tS32)         -4)
#define DIA_ERR_S32_DRIVER_INVALID_LENGTH                ((tS32)         -5)
#define DIA_ERR_S32_DRIVER_CHECKSUM                      ((tS32)         -6)
#define DIA_ERR_S32_DRIVER_OPEN_FAILED                   ((tS32)         -7)
#define DIA_ERR_S32_DRIVER_CLOSE_FAILED                  ((tS32)         -8)
#define DIA_ERR_S32_DRIVER_NOT_IMPLEMENTED               ((tS32)         -9)
#define DIA_ERR_S32_DRIVER_NOT_SUPPORTED                 ((tS32)        -10)

#define DIA_BOOL_CTRL_SETTINGS_MODE_PERMANENT            ((bool)       true)
#define DIA_BOOL_CTRL_SETTINGS_MODE_VOLATILE             ((bool)      false)

class dia_IDriver
{
public:
   dia_IDriver ( void )
      : mFlushCtrl(DIA_C_U16_FLUSH_CTRL_DEFAULT_MASK),
        mCtrlSettings(DIA_C_U32_CTRL_SETTINGS_DEFAULT_MASK),
        mCtrlSettingsVolatile(DIA_C_U32_CTRL_SETTINGS_DEFAULT_MASK)
   {}
   virtual ~dia_IDriver ( void ) {}

   //! open the driver
   virtual tDiaResult open ( void ) = 0;
   //! close the driver
   virtual tDiaResult close ( void ) = 0;
   //! native read from KDS
   virtual tS32 read ( tU8 data[], tU16 length ) = 0;
   //! native write to KDS
   virtual tS32 write ( tU8 data[], tU16 length ) = 0;
   //! iocontrol
   virtual tDiaResult ioctrl ( tS32 func, intptr_t arg ) = 0;
   //! native flushing of KDS
   virtual tDiaResult flush ( void ) { return DIA_E_NOT_SUPPORTED; }
   //! return flush control settings
   virtual tU16 getFlushCtrl ( void ) const { return mFlushCtrl; }
   //! set bits according to the given bit mask
   virtual tDiaResult clearFlushCtrlBits ( void ) { mFlushCtrl = 0; return DIA_SUCCESS; }
   //! set bits according to the given bit mask
   virtual tDiaResult setFlushCtrlBits ( tU16 bitMask ) { mFlushCtrl |= bitMask; return DIA_SUCCESS; }
   //! clear bits according to the given bit mask
   virtual tDiaResult resetFlushCtrlBits ( tU16 bitMask ) { mFlushCtrl &= static_cast<tU16>(~bitMask); return DIA_SUCCESS; }
   //! return control settings
   virtual tU32 getCtrlSettings ( void ) const { return mCtrlSettings; }
   //! set bits according to the given bit mask
   virtual tDiaResult setCtrlSettings ( tU32 settingsMask, bool mode=DIA_BOOL_CTRL_SETTINGS_MODE_PERMANENT ) 
   {
      mCtrlSettings |= settingsMask; 
      if (mode == DIA_BOOL_CTRL_SETTINGS_MODE_VOLATILE) 
      {
         mCtrlSettingsVolatile |= settingsMask; 
      }
      mFlushCtrl = static_cast<tU16>(mFlushCtrl | settingsMask); 
      return DIA_SUCCESS;
   }
   //! clear bits according to the given bit mask
   virtual tDiaResult resetCtrlSettings ( tU32 settingsMask ) {
      mCtrlSettings &= (~settingsMask); mCtrlSettingsVolatile &= (~settingsMask); mFlushCtrl &= ((tU16) (~settingsMask)); return DIA_SUCCESS;
   }
   //! check for the given bitMask
   virtual tBool checkFlushCtrlBits ( tU16 bitMask ) { return (mFlushCtrl & bitMask) ? TRUE : FALSE; }


protected:
   //! set mask bit of flush option of the KDS device
   virtual tDiaResult flushCtrl ( tU16 ctrlMask = DIA_C_U16_FLUSH_CTRL_DEFAULT_MASK ) { mFlushCtrl = ctrlMask; return DIA_SUCCESS; }  //lint !e1735: checked that default param is equal to base class default param
   //! flush control settings
   tU16 mFlushCtrl;
   //! concrete control settings (will be evaluated by the concrete driver)
   tU32 mCtrlSettings;
   //! concrete volatile control settings (will be evaluated by the concrete driver and will be reset after the nex read/write operation)
   tU32 mCtrlSettingsVolatile;
};

#endif /* __INCLUDED_DIA_INTERFACE_DRIVER__ */
