/**
 * \file      dia_CommandControllerPluginServiceCCA.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      Oct 2, 2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER_PLUGIN_SERVICE_CCA__
#include "common/framework/platform/cca/dia_CommandControllerPluginServiceCCA.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include "common/framework/application/dia_CommandController.h"
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include "common/framework/application/dia_Command.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_STATE_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceStateCCA.h"
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_REGISTRATION_CCA__
#include "common/framework/platform/cca/dia_PredicateServiceRegistrationCCA.h"
#endif
#include <string.h>

using namespace dia;

//-----------------------------------------------------------------------------

dia_CommandControllerPluginServiceCCA::dia_CommandControllerPluginServiceCCA ( void )
   : dia_CommandControllerPlugin(DIA_EN_CMD_CTRL_PLUGIN_TYPE_SERVICE_CCA)
{}

//-----------------------------------------------------------------------------

dia_CommandControllerPluginServiceCCA::~dia_CommandControllerPluginServiceCCA ( void )
{}

//-----------------------------------------------------------------------------

void
dia_CommandControllerPluginServiceCCA::vOnServiceRegistration ( tU16 serviceID, tU16 serverID, tU16 regID )
{
   ScopeTrace trc("dia_CommandControllerPluginServiceCCA::vOnServiceRegistration()");

   std::vector<tU32> args;
   args.push_back(serviceID);
   args.push_back(serverID);
   args.push_back(regID);
   std::string str = dia_composeStlString("%s_%04x_%04x",DIA_PRED_CCA_SRV_REG,serviceID,serverID);//Coverity Fix(CID:117753)
   if ( !str.empty()  )
   {
     dia_UID uid = dia_getHashCodeFromString(str);
     getInstanceOfCommandController()->update(uid,args);
   }
}

//-----------------------------------------------------------------------------

void
dia_CommandControllerPluginServiceCCA::vOnServiceState ( tU16 serviceID, tU16 serverID, tBool availability )
{
   ScopeTrace trc("dia_CommandControllerPluginServiceCCA::vOnServiceState()");

#ifndef __DIA_UNIT_TESTING__
   getInstanceOfApplication()->postMessage (
         new dia_tclDiagSession::tclEventIntMsgRxGeneric (
               new dia_FunctorThreeArgsNoReturnValue< dia_CommandControllerPluginServiceCCA, tU16, tU16, tBool >(this, &dia_CommandControllerPluginServiceCCA::vOnServiceStateChange, serviceID, serverID, availability)
         )
   );
#else
   vOnServiceStateChange(serviceID,serverID,availability);
#endif
}

//-----------------------------------------------------------------------------

void
dia_CommandControllerPluginServiceCCA::vOnServiceStateChange ( tU16 serviceID, tU16 serverID, tBool availability )
{
   ScopeTrace trc("dia_CommandControllerPluginServiceCCA::vOnServiceStateChange()");

   std::vector<tU32> args;
   args.push_back(serviceID);
   args.push_back(serverID);
   args.push_back(availability);

   std::string str = dia_composeStlString("%s_%04x_%04x_%s",DIA_PRED_CCA_SRV_STATE,serviceID,serverID,((availability) ? "TRUE" : "FALSE"));
   if ( !str.empty() )
   {
      dia_UID uid = dia_getHashCodeFromString(str);
      getInstanceOfCommandController()->update(uid,args);
   }
}
