/*
 * dia_SystemAdapterServicePluginASF.h
 *
 *  Created on: 02.12.2013
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_CONDVAR__
#include <common/framework/application/dia_CondVar.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND_CONTROLLER__
#include <common/framework/application/dia_CommandController.h>
#endif

#ifndef __INCLUDED_DIA_COMMAND__
#include <common/framework/application/dia_Command.h>
#endif

#ifndef __INCLUDED_DIA_PREDICATE_SERVICE_ASF__
#include "dia_PredicateServiceASF.h"
#endif

#include <asf/core/Proxy.h>
#include <list>
#include <string>

using namespace ::boost;
using namespace ::asf::core;

class dia_SystemAdapterASF;
template <class _Proxy> class dia_SystemAdapterFeatureASF;

//----------------------------------------------------------------------------------------

template <class _Proxy>
class dia_SystemAdapterServicePluginASF
   : public ServiceAvailableIF
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapterServicePluginASF);

public:
   //! default constructor
   dia_SystemAdapterServicePluginASF ( tCString name, const boost::shared_ptr<_Proxy>& proxy, const std::shared_ptr<dia_SystemAdapterASF>& adapter )
      : mpAdapter(adapter),
        mProxy(proxy),
        mCondVar(std::string(std::string(name) + "_CV").c_str()),
        mCondVarRetries(5),
        mConditionTimeout(2000),
        mConditionMask(DIA_C_CONDVAR_EVENT_01),
        mIsAvailable(false)
   {}

   //! class destructor
   virtual ~dia_SystemAdapterServicePluginASF ( void )
   {
      mpAdapter = OSAL_NULL;
   }

   //! ServiceAvailableIF implementation
   virtual void onAvailable ( const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange );
   virtual void onUnavailable ( const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange );

   bool isAvailable ( void ) const { return mIsAvailable; }

   // helper methods used to customize the condition variable
   void setCondVarRetries ( tU16 retries ) { mCondVarRetries = retries; }
   void setCondVarTimeout ( tU16 msecs ) { mConditionTimeout = msecs; }

   //! add a new feature to this service plugin
   tDiaResult addFeature(dia_SystemAdapterFeatureASF<_Proxy>& feature)
   {
      mFeatureRep.push_back(&feature);
      return DIA_SUCCESS;
   }

   _Proxy* getProxy()
   {
      _Proxy* p = NULL;

      for ( tU32 i=0; i<mCondVarRetries; i++ )
      {
         tDiaResult result = mCondVar.wait(mConditionMask, mConditionTimeout);
         if ( result == DIA_SUCCESS )
         {
            p = get_pointer(mProxy);
            break;
         }
      }

      return p;
   }

   //! returns the port name for which the ASF Proxy was created
   const std::string& getPortName() const { return mProxy->getPortName(); }

   //! creates a predicate for the service availability of the ASF Proxy
   virtual std::unique_ptr<dia_Predicate> getPredicateServiceState();

   //! executes a functor based on the service availability predicate
   virtual tDiaResult executeServiceFunctor(std::unique_ptr<dia_Functor> pFunctor);

protected:
   //! deprecated default constructor
   dia_SystemAdapterServicePluginASF();

protected:
   //! pointer to the owner of this plugin
   std::shared_ptr<dia_SystemAdapterASF> mpAdapter;
   //! pointer to the ASF service proxy
   boost::shared_ptr<_Proxy> mProxy;
   //! list of pointers to concrete SystemAdapterFeatures
   std::list< dia_SystemAdapterFeatureASF<_Proxy>* > mFeatureRep;
   // synchronization condition variable
   dia_CondVar mCondVar;
   //! number of condition variable monitored send retries
   tU16 mCondVarRetries;
   //! condition variable timeout value
   tU16 mConditionTimeout;
   //! condition bitmask monitiored by the condition variable
   tU32 mConditionMask;
   //! flag that indicates if the service is available or not
   bool mIsAvailable;
};

//-----------------------------------------------------------------------------

template <class _Proxy>
void
dia_SystemAdapterServicePluginASF<_Proxy>::onAvailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if (proxy == mProxy)
   {
      switch (stateChange.getCurrentState())
      {
         case ServiceState__Available:
            {
               mCondVar.signal(DIA_C_CONDVAR_EVENT_01,TRUE);

               mIsAvailable = true;

               std::vector<tU32> args;
               args.push_back(mIsAvailable);
               getInstanceOfCommandController()->update(dia_PredicateServiceASF<_Proxy>::getUID(*this), args);

               typename std::list< dia_SystemAdapterFeatureASF<_Proxy>* >::iterator iter = mFeatureRep.begin();
               for ( ; iter != mFeatureRep.end(); iter++ )
               {
//                (*iter)->dia_SystemAdapterFeatureASF<_Proxy>::onServiceAvailable();

#ifndef __DIA_UNIT_TESTING__
                  getInstanceOfApplication()->postMessage (
                        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                              OSAL_NEW dia_FunctorNoArgs< dia_SystemAdapterFeatureASF<_Proxy> >(*iter,&dia_SystemAdapterFeatureASF<_Proxy>::onServiceAvailable)
                        )
                  );
#endif
               }
            }
            break;

         default:
            break;
      }
   }
}

//----------------------------------------------------------------------------------------

template <class _Proxy>
void
dia_SystemAdapterServicePluginASF<_Proxy>::onUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange& stateChange)
{
   if (proxy == mProxy)
   {
      switch (stateChange.getCurrentState())
      {
         case ServiceState__Disconnected:
         case ServiceState__Suspended:
            {
               mCondVar.signal(DIA_C_CONDVAR_EVENT_01,FALSE);

               mIsAvailable = false;

               std::vector<tU32> args;
               args.push_back(mIsAvailable);
               getInstanceOfCommandController()->update(dia_PredicateServiceASF<_Proxy>::getUID(*this), args);

               typename std::list< dia_SystemAdapterFeatureASF<_Proxy>* >::iterator iter = mFeatureRep.begin();
               for ( ; iter != mFeatureRep.end(); iter++ )
               {
//                (*iter)->dia_SystemAdapterFeatureASF<_Proxy>::onServiceUnavailable();

#ifndef __DIA_UNIT_TESTING__
                  getInstanceOfApplication()->postMessage (
                        OSAL_NEW dia_tclDiagSession::tclEventIntMsgRxGeneric (
                              OSAL_NEW dia_FunctorNoArgs< dia_SystemAdapterFeatureASF<_Proxy> >(*iter,&dia_SystemAdapterFeatureASF<_Proxy>::onServiceUnavailable)
                        )
                  );
#endif
               }
            }
            break;

         default:
            break;
      }
   }
}

//----------------------------------------------------------------------------------------

template <class _Proxy>
std::unique_ptr<dia_Predicate>
dia_SystemAdapterServicePluginASF<_Proxy>::getPredicateServiceState()
{
   return std::unique_ptr<dia_Predicate>(new dia_PredicateServiceASF<_Proxy>(*this));
}

//----------------------------------------------------------------------------------------

template <class _Proxy>
tDiaResult dia_SystemAdapterServicePluginASF<_Proxy>::executeServiceFunctor(std::unique_ptr<dia_Functor> pFunctor)
{
   tDiaResult retCode = DIA_FAILED;

   std::unique_ptr<dia::Command> pCmd(new dia::Command);
   if (pCmd != nullptr)
   {
      std::unique_ptr<dia_Predicate> pPredicate = getPredicateServiceState();
      if ((pPredicate != nullptr) && (pCmd->addPredicate(pPredicate.release()) == DIA_SUCCESS))
      {
         if ((pFunctor != nullptr) && (pCmd->addFunctor(pFunctor.release()) == DIA_SUCCESS))
         {
            retCode = getInstanceOfCommandController()->addCommand(pCmd.release());
         }
      }
   }

   return retCode;
}

#endif /* __INCLUDED_DIA_SYSTEM_ADAPTER_SERVICE_PLUGIN_ASF__ */
