/*
 * dia_SystemAdapterFeatureASF.h
 *
 *  Created on: 02.12.2013
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__
#define __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDE_DIA_FUNCTOR__
#include <common/framework/application/dia_Functor.h>
#endif

template <class _Proxy> class dia_SystemAdapterServicePluginASF;

typedef tDiaResult (*tFuncMonitoringAction) ( void* cookie );
//----------------------------------------------------------------------------------------

template <class _Proxy>
class dia_SystemAdapterFeatureASF
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SystemAdapterFeatureASF);

public:
   //! default constructor
   dia_SystemAdapterFeatureASF ( dia_SystemAdapterServicePluginASF<_Proxy>& pSrvPlugin )
      : mpSrvPlugin(&pSrvPlugin),
        mpCookie(0),
        mpCustomStartMonitoringAction(0),
        mpCustomStopMonitoringAction(0)
   {}

   //! class destructor
   virtual ~dia_SystemAdapterFeatureASF ( void )
   {
      mpSrvPlugin = NULL;
   }

   //! start monitoring of properties / signals...
   tDiaResult onServiceAvailable ( void ) { return ( mpCustomStartMonitoringAction ) ? mpCustomStartMonitoringAction(mpCookie) : startMonitoring(); /*onServiceAvailabilityDefaultAction(mpCookie);*/ }
   //! stop monitoring of properties / signals...
   tDiaResult onServiceUnavailable ( void ) { return ( mpCustomStopMonitoringAction  ) ? mpCustomStopMonitoringAction(mpCookie)  : stopMonitoring(); /*onServiceUnavailabilityDefaultAction(mpCookie);*/ }

   //! start monitoring of properties / signals...
   virtual tDiaResult startMonitoring ( void ) { return DIA_SUCCESS; }
   //! stop monitoring of properties / signals...
   virtual tDiaResult stopMonitoring  ( void ) { return DIA_SUCCESS; }

   tDiaResult customizeMonitoring ( tFuncMonitoringAction startAction, tFuncMonitoringAction stopAction, void* cookie )
   {
      if ( !cookie ) return DIA_FAILED;
      mpCookie = cookie;
      mpCustomStartMonitoringAction = startAction;
      mpCustomStopMonitoringAction  = stopAction;
      return DIA_SUCCESS;
   }

protected:
   //! default constructor used by subclasses with own service plugin management
   dia_SystemAdapterFeatureASF ( void );

   template <class CallbackIF, typename... Args>
   class FunctorSendRequest : public dia_Functor
   {
      //! proxy to send the ASF request
      std::function<_Proxy*()> mGetProxy;
      //! ASF response callback
      CallbackIF* mpCallbackIF;
      //! ASF request parameters
      std::tuple<Args...> mArgs;

   public:
      FunctorSendRequest() = delete;
      FunctorSendRequest ( std::function<_Proxy*()> getProxy, CallbackIF* pCallbackIF, const Args&... args)
         : mGetProxy(getProxy), mpCallbackIF(pCallbackIF), mArgs(args...)
      {}

      virtual ~FunctorSendRequest () {}
      //! override operator "()" in order to call the member function with stored arguments
      tDiaResult operator() ( void ) override;
   };

protected:
   //! pointer to the associated service plugin
   dia_SystemAdapterServicePluginASF<_Proxy>* mpSrvPlugin;
   //! cookie
   void* mpCookie;
   //! customizable start monitoring action
   tFuncMonitoringAction mpCustomStartMonitoringAction;
   //! customizable stop monitoring action
   tFuncMonitoringAction mpCustomStopMonitoringAction;
};

#endif /* __INCLUDED_DIA_SYSTEM_ADAPTER_FEATURE_ASF__ */
