/*
 * dia_ASFComponentWifiBL.cpp
 *
 *  Created on: Sept 25, 2017
 *      Author: stc2hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_WIFI_BL_CONFLICTMANAGEMENT__
#include <common/framework/sysadapters/dia_SAFeatureWifiBLConflictManagement.h>
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_WIFI_CONNMAN__
#include <common/framework/sysadapters/dia_SAFeatureWifiConnman.h>
#endif

#ifndef ORG_BOSCH_WBL_CONFLICTMANAGEMENTPROXY_H
#include <org/bosch/wbl/conflictmanagementProxy.h>
#endif

#ifndef NET_CONNMAN_MANAGERPROXY_H
#include <net/connman/ManagerProxy.h>
#endif

#include "dia_ASFComponentWifiBL.h"

using namespace org::bosch::wbl::conflictmanagement;
using namespace net::connman::Manager;

namespace asf {

dia_ASFComponentWifiBL::dia_ASFComponentWifiBL()
{
   dia_tclFnctTrace oTrace("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   //
   // asf System Adapter object
   //
   std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter = createSystemAdapter();
   if (NULL!=pSystemAdapter)
   {
      DIA_TR_INF("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. pSystemAdapter was initialized.");
   }
   else
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: pSystemAdapter = NULL");
      return;
   }

   boost::shared_ptr< ConflictmanagementProxy > wifiBLProxy = ConflictmanagementProxy::createProxy("wifiBLPort", *pSystemAdapter);
   if (NULL!=wifiBLProxy)
   {
      DIA_TR_INF("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. wifiBLProxy was initialized.");
   }
   else
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: wifiBLProxy = NULL");
      return;
   }

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< ConflictmanagementProxy >* pSAWifiBLConflictManagementSrv =
         dia_ASFComponent::createSystemAdapterServicePlugin<ConflictmanagementProxy>("DIA_SAWifiBLSrv", wifiBLProxy, pSystemAdapter);
   if (NULL!=pSAWifiBLConflictManagementSrv)
   {
      DIA_TR_INF("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. pSAWifiBLConflictManagementSrv was initialized.");
   }
   else
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: pSAWifiBLConflictManagementSrv = NULL");
      return;
   }

   //
   // Feature Plugins
   //
   dia_SAFeatureWifiBLConflictManagement* pSAFeatureWifiBLConflictManagement =
         dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureWifiBLConflictManagement, ConflictmanagementProxy>(pSAWifiBLConflictManagementSrv);
   if ( NULL!=pSAFeatureWifiBLConflictManagement )
   {
      retCode = assignInterfaceAndNotifier<dia_IWifiSetups, dia_IWifiSetupsListener, dia_IWifiSetupsNotifier>(pSAFeatureWifiBLConflictManagement);
      if (retCode != DIA_SUCCESS)
      {
         DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL Failed to assign interface dia_IWifiSetups (retCode = 0x%08X).", retCode);
         return;
      }
   }
   else
   {
      DIA_TR_ERR("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: pSAFeatureWifiBLConflictManagement = NULL");
      return;
   }

   //-------------------------------------------------------------------------------

   boost::shared_ptr< ManagerProxy > connManProxy =  ManagerProxy::createProxy("connmanManagerPort", *pSystemAdapter);
   if (connManProxy.get())
   {
      DIA_TR_INF("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. connManProxy.get() = OK");
   }
   else
   {
      DIA_TR_ERR("### dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: connManProxy = NULL");
      return;
   }

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< ManagerProxy >* pSAWifiConnmanSrv = dia_ASFComponent::createSystemAdapterServicePlugin<ManagerProxy>("DIA_SAWifiConnManSrv", connManProxy, pSystemAdapter);
   if (pSAWifiConnmanSrv)
   {
      DIA_TR_INF("dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. pSAWifiConnmanSrv = OK");
   }
   else
   {
      DIA_TR_ERR("### dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: pSAWifiConnmanSrv = NULL");
      return;
   }

   //
   // Feature Plugins
   //
   dia_SAFeatureWifiConnman* pSAFeatureWifiConnman = dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureWifiConnman, ManagerProxy>(pSAWifiConnmanSrv);

   if ( pSAFeatureWifiConnman )
   {
      retCode = assignInterfaceAndNotifier<dia_IWifiConnman, dia_IWifiConnmanListener, dia_IWifiConnmanNotifier>(pSAFeatureWifiConnman);
      if (retCode != DIA_SUCCESS)
      {
         DIA_TR_ERR("### Failed to assign interface dia_IWifiConnman (retCode = 0x%08X).", retCode);
      }
   }
   else
   {
      DIA_TR_ERR("### dia_ASFComponentWifiBL::dia_ASFComponentWifiBL. Error: pSAFeatureWifiConnman = NULL");
   }
}

dia_ASFComponentWifiBL::~dia_ASFComponentWifiBL()
{
}

} //namespace asf
