#ifndef __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_SETTINGS__
#define __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_SETTINGS__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT__
#include <project/framework/platform/asf/dia_ASFComponent.h>
#endif

#include "asf/core/BaseComponent.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "asf/core/ComponentFactory.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1ClientBase.h" //lint !e451 !e537 repeatedly included header file without standard include guard

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

class dia_SAFeatureSystemSettingsASF;

namespace asf {

class dia_ASFComponentSystemSettings
   : public dia_ASFComponent, //BaseComponent,
     public SystemSettings1Stub
{
   /*lint -save -e1704 class constructor could be private, because this class is not referenced at the moment. ;) */
   friend BaseComponent* ComponentFactory<dia_ASFComponentSystemSettings>::getComponent();

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_ASFComponentSystemSettings);

public:
   //! default class destructor
   virtual ~dia_ASFComponentSystemSettings();

   virtual void onPrepareSystemSettingRequest (const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
   virtual void onExecuteSystemSettingRequest (const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
   virtual void onFinalizeSystemSettingRequest (const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

protected:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentSystemSettings>::getComponent()
   dia_ASFComponentSystemSettings();
   /*lint -restore */

protected:
   //! list of system setting module
   std::list<dia_SAFeatureSystemSettingsASF*> mModuleRep;
};

} //namespace asf

#endif /* __INCLUDED_DIA_ASF_COMPONENT_SYSTEM_SETTINGS__ */
