/*
 * dia_ASFComponentSystemSettings.cpp
 *
 *  Created on: 03.07.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_MANAGER__
#include <common/framework/sysset/dia_SystemSettingsManager.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_SETTINGS_CONFIGURATION__
#include <common/framework/sysset/dia_SystemSettingsConfiguration.h>
#endif


#include "dia_ASFComponentSystemSettings.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1ClientBase.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Proxy.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include <common/framework/sysadapters/dia_SAFeatureSystemSettingsASF.h>

//// TBD: move to configuration object for system settings manager
//static const dia_SystemSettingsConfigurationASF arSystemSettingsConfigurationASF[] = {
//      { "diagSystemSettingLoopbackClientPort", "DIA_SrvSysSetASF_Diag", "DIA_SAFeatureSystemSettingASF_LoopbackServer", "DIA_SYSSET_ID_DIAGNOSIS", 0xFFFFFFFF  }
//};

using namespace ::boost;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentSystemSettings::dia_ASFComponentSystemSettings ( void )
   : SystemSettings1Stub("diagSystemSettingLoopbackServerPort")
{
   dia_tclFnctTrace trc("dia_ASFComponentSystemSettings::dia_ASFComponentSystemSettings");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   dia_FactoryPlugin* pSysSetFactory = 0;
   if ( (pFactory->queryFactoryPlugin("dia_FactoryPluginSystemSettings",&pSysSetFactory) != DIA_SUCCESS) || (!pSysSetFactory) )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to SystemSettings factory !!");
      return;
   }

   if ( pSysSetFactory->setup(DIA_EN_INITLEVEL_2) != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_2 of SystemSettings factory !!!");
      return;
   }

   dia_SystemSettingsManager* pSysSetMgr = getInstanceOfSystemSettingsManager();
   if ( pSysSetMgr )
   {
      dia_SystemSettingsConfiguration* pSysSetConfig = pSysSetMgr->getConfiguration();
      if ( pSysSetConfig )
      {
         const std::list<dia_SystemSettingsConfigurationASF*>& config = pSysSetConfig->getConfigurationASF();

         if (config.size())
         {
            //
            // System Adapter object
            //
            std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter = createSystemAdapter();

            //
            // create service plugin and feature for each connection
            //

            std::list<dia_SystemSettingsConfigurationASF*>::const_iterator cfgIter = config.begin();
            for ( ; cfgIter != config.end(); cfgIter++ )
            {
               dia_SystemSettingsConfigurationASF* pConfigItem = *cfgIter;

               if ( !pConfigItem ) continue;

               if ( pConfigItem->pFunctor )
               {
            	   if((*pConfigItem->pFunctor)() == DIA_SUCCESS)
            	   {
            		   OSAL_DELETE pConfigItem->pFunctor;
            		   pConfigItem->pFunctor = 0;
            	   }
            	   else
            	   {
            		   OSAL_DELETE pConfigItem->pFunctor;
            		   pConfigItem->pFunctor = 0;
            		   continue; //specific condition check failed, continue with the next item
            	   }
               }

               // create proxy object
               boost::shared_ptr<SystemSettings1Proxy> proxy = SystemSettings1Proxy::createProxy (
                     pConfigItem->mPortName.c_str(), *pSystemAdapter
               );

               // create service plugin
               dia_SystemAdapterServicePluginASF< SystemSettings1Proxy >* pSASystemSettingService1 = dia_ASFComponent::createSystemAdapterServicePlugin<SystemSettings1Proxy> (
                     pConfigItem->mSAServicePluginName.c_str(), proxy, pSystemAdapter
               );

               if ( pSASystemSettingService1 )
               {
                  dia_SAFeatureSystemSettingsASF* pSAFeatureSystemSetting1 = new dia_SAFeatureSystemSettingsASF (
                        pConfigItem->mSAFeatureName.c_str(),
                        pConfigItem->mSystemSettingID.c_str(),
                        pConfigItem->mSystemSettingTypeMask,
                        *pSASystemSettingService1
                  );

                  if ( pSAFeatureSystemSetting1 )
                  {
                     pSASystemSettingService1->addFeature(*pSAFeatureSystemSetting1);

                     if ( getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSystemSetting1) != DIA_SUCCESS )
                     {
                        DIA_TR_ERR("!!! Error: Failed to add module \"%s\" to system settings manager",pSAFeatureSystemSetting1->getName());
                     }

                     // store pointer of created object in repository to delete it on system shutdown
                     mModuleRep.push_back(pSAFeatureSystemSetting1);
                  }
               } //lint !e429: custodial pointer is freed when the list is full or by destroy function
            }
         } //if (config.size())
         else
         {
            DIA_TR_ERR("!!! Error: ASF System Settings configuration is empty !!");
         }
      }
      else
      {
         DIA_TR_ERR("!!! Error: No configuration object found !!");
      }
   }
   else
   {
      DIA_TR_ERR("!!! Error: Unable to get pointer to SystemSettingsManager instance !!");
   }
}

////------------------------------------------------------------------------------
//
//dia_ASFComponentSystemSettings::dia_ASFComponentSystemSettings ( void )
//   : SystemSettings1Stub("diagSystemSettingLoopbackServerPort")
//{
//   dia_tclFnctTrace trc("dia_ASFComponentSystemSettings::dia_ASFComponentSystemSettings");
//
//   //
//   // create system Adapter object
//   //
//   dia_SystemAdapterASF* pSystemAdapter = createSystemAdapter();
//
//   //
//   // create service plugin and feature for each connection
//   //
//
//   for ( tU16 i=0; i<(sizeof(arSystemSettingsConfigurationASF)/sizeof(dia_SystemSettingsConfigurationASF)); i++ )
//   {
//      // create proxy object
//      shared_ptr< SystemSettings1Proxy > proxy = SystemSettings1Proxy::createProxy (
//            arSystemSettingsConfigurationASF[i].mPortName.c_str(),
//            *pSystemAdapter
//      );
//
//      // create service plugin
//      dia_SystemAdapterServicePluginASF< SystemSettings1Proxy >* pSASystemSettingService1 = dia_ASFComponent::createSystemAdapterServicePlugin<SystemSettings1Proxy> (
//            arSystemSettingsConfigurationASF[i].mSAServicePluginName.c_str(),
//            proxy,
//            pSystemAdapter
//      );
//
//      if ( pSASystemSettingService1 )
//      {
//         dia_SAFeatureSystemSettingsASF* pSAFeatureSystemSetting1 = new dia_SAFeatureSystemSettingsASF (
//               arSystemSettingsConfigurationASF[i].mSAFeatureName.c_str(),
//               arSystemSettingsConfigurationASF[i].mSystemSettingID.c_str(),
//               arSystemSettingsConfigurationASF[i].mSystemSettingTypeMask,
//               *pSASystemSettingService1
//         );
//
//         if ( pSAFeatureSystemSetting1 )
//         {
//            pSASystemSettingService1->addFeature(*pSAFeatureSystemSetting1);
//
//            if ( getInstanceOfSystemSettingsManager()->addSystemSettingsModule(*pSAFeatureSystemSetting1) != DIA_SUCCESS )
//            {
//               DIA_TR_ERR("!!! dia_ASFComponentSystemSettings::dia_ASFComponentSystemSettings => Error: Failed to add module \"%s\" to system settings manager",pSAFeatureSystemSetting1->getName());
//            }
//
//            // store pointer of created object in repository to delete it on system shutdown
//            mModuleRep.push_back(pSAFeatureSystemSetting1);
//         }
//      } //lint !e429: custodial pointer is freed when the list is full or by destroy function
//   }
//}

//------------------------------------------------------------------------------

dia_ASFComponentSystemSettings::~dia_ASFComponentSystemSettings()
{
   _BP_TRY_BEGIN
   {
      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_SAFeatureSystemSettingsASF,mModuleRep)
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_ASFComponentSystemSettings::~dia_ASFComponentSystemSettings !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//------------------------------------------------------------------------------

void
dia_ASFComponentSystemSettings::onPrepareSystemSettingRequest (const ::boost::shared_ptr< PrepareSystemSettingRequest >& request )
{
   dia_tclFnctTrace trc("dia_ASFComponentSystemSettings::onPrepareSystemSettingRequest()");

   std::vector<PrepareSystemSettingResponseExtendedDataStruct> responseExtDataVec;
   for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
   {
      PrepareSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
      responseExtDataVec.push_back(elem);
   }

   sendPrepareSystemSettingResponse(request->getSysSetID(), request->getSysSetType(),responseExtDataVec,DIA_SUCCESS,request->getCookie(),request->getAct());
}

//------------------------------------------------------------------------------

void
dia_ASFComponentSystemSettings::onExecuteSystemSettingRequest (const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request)
{
   dia_tclFnctTrace trc("dia_ASFComponentSystemSettings::onExecuteSystemSettingRequest()");

   std::vector<ExecuteSystemSettingResponseExtendedDataStruct> responseExtDataVec;
   for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
   {
      ExecuteSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
      responseExtDataVec.push_back(elem);
   }

   sendExecuteSystemSettingResponse(request->getSysSetID(), request->getSysSetType(),responseExtDataVec,DIA_SUCCESS,request->getCookie(),request->getAct());
}

//------------------------------------------------------------------------------

void
dia_ASFComponentSystemSettings::onFinalizeSystemSettingRequest (const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request)
{
   dia_tclFnctTrace trc("dia_ASFComponentSystemSettings::onFinalizeSystemSettingRequest()");

   std::vector<FinalizeSystemSettingResponseExtendedDataStruct> responseExtDataVec;
   for ( tU16 i=0; i<request->getExtendedData().size(); i++ )
   {
      FinalizeSystemSettingResponseExtendedDataStruct elem((request->getExtendedData())[i].getElem1(),(request->getExtendedData())[i].getElem2());
      responseExtDataVec.push_back(elem);
   }

   sendFinalizeSystemSettingResponse(request->getSysSetID(), request->getSysSetType(),responseExtDataVec,DIA_SUCCESS,request->getCookie(),request->getAct());
}

} //namespace asf

