/*
 * dia_ASFComponentServer.h
 *
 *  Created on: 07.07.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ASF_COMPONENT_SERVER__
#define __INCLUDED_DIA_ASF_COMPONENT_SERVER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SYSTEMSETTINGS_LISTENER__
#include <common/interfaces/dia_ISystemSettingsListener.h>
#endif

#include "asf/core/BaseComponent.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "asf/core/ComponentFactory.h" //lint !e451 !e537 repeatedly included header file without standard include guard
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/Control1Stub.h" //lint !e451 !e537 repeatedly included header file without standard include guard


using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::Control1;

namespace asf {

class dia_ASFComponentServer
   : public BaseComponent,
     public Control1Stub,
     public dia_ISystemSettingsListener
{
   /*lint -save -e1704 class constructor could be private, because this class is not referenced at the moment. ;) */
   friend BaseComponent* ComponentFactory<dia_ASFComponentServer>::getComponent();

   struct dia_RemoteControlRequestInfo
   {
      dia_RemoteControlRequestInfo ( void )
         : mArea(DIA_C_STR_REMOTE_CONTROL_AREA_UNKNOWN), mAreaID(DIA_C_UID_REMOTE_CONTROL_AREA_UNKNOWN),
           mMode(DIA_C_STR_REMOTE_CONTROL_MODE_UNKNOWN), mModeID(DIA_C_UID_REMOTE_CONTROL_MODE_UNKNOWN),
           mCookie(0), mACT(0)
      {}

      dia_RemoteControlRequestInfo ( const std::string& area, const std::string& mode, tU32 cookie, act_t act )
         : mArea(area), mMode(mode), mCookie(cookie), mACT(act)
      {
         mAreaID = getInstanceOfHashCalculator()->getHashCode((const tU8*) const_cast<std::string&>(area).c_str(), (tU16) area.size());
         mModeID = getInstanceOfHashCalculator()->getHashCode((const tU8*) const_cast<std::string&>(mode).c_str(), (tU16) mode.size());
      }

      std::string mArea;
      dia_UID     mAreaID;
      std::string mMode;
      dia_UID     mModeID;
      tU32        mCookie;
      act_t       mACT;
   };

   struct dia_SystemSettingRequestInfo
   {
      dia_SystemSettingRequestInfo ( void )
         : mType(DIA_C_STR_SYSTEM_SETTING_TYPE_UNKNOWN), mTypeID(DIA_C_UID_SYSTEM_SETTING_TYPE_UNKNOWN), mLevelID(DIA_EN_SYSTEM_SETTING_LEVEL_UNKNOWN), mCookie(0), mACT(0)
      {}

      dia_SystemSettingRequestInfo ( const std::string& type, dia_enSystemSettingLevel level, const dia_SystemSettingExtendedData& extData, const tU32 cookie, act_t act )
         : mType(type), mLevelID(level), mExtData(extData), mCookie(cookie), mACT(act)
      {
         mTypeID = getInstanceOfHashCalculator()->getHashCode((const tU8*) const_cast<std::string&>(type).c_str(), (tU16) type.size());
      }

      dia_SystemSettingRequestInfo ( const std::string& type, const dia_SystemSettingExtendedData& extData, const tU32 cookie, act_t act )
         : mType(type), mLevelID(DIA_EN_SYSTEM_SETTING_LEVEL_UNKNOWN), mExtData(extData), mCookie(cookie), mACT(act)
      {
         mTypeID = getInstanceOfHashCalculator()->getHashCode((const tU8*) const_cast<std::string&>(type).c_str(), (tU16) type.size());
      }

      std::string mType;
      dia_UID     mTypeID;
      dia_enSystemSettingLevel mLevelID;
      dia_SystemSettingExtendedData mExtData;
      tU32        mCookie;
      act_t       mACT;
   };

private:
   //! default class constructor called only by ComponentFactory<dia_ASFComponentAudioManager>::getComponent()
   dia_ASFComponentServer();
   /*lint -restore */

   tDiaResult checkRemoteControlArea ( const std::string& strArea ) const;
   tDiaResult checkRemoteControlMode ( const std::string& strMode, dia_enSystemSettingMode& mode ) const;


public:
   //! default class destructor
   virtual ~dia_ASFComponentServer();

   virtual void onSetRemoteControlModeRequest (const ::boost::shared_ptr< SetRemoteControlModeRequest >& request);
   virtual void onGetRemoteControlModeRequest (const ::boost::shared_ptr< GetRemoteControlModeRequest >& request);
   virtual void onStartSystemSettingRequest (const ::boost::shared_ptr< StartSystemSettingRequest >& request);
   virtual void onRemotePrepareSystemSettingRequest (const ::boost::shared_ptr< RemotePrepareSystemSettingRequest >& request);
   virtual void onRemoteExecuteSystemSettingRequest (const ::boost::shared_ptr< RemoteExecuteSystemSettingRequest >& request);
   virtual void onRemoteFinalizeSystemSettingRequest (const ::boost::shared_ptr< RemoteFinalizeSystemSettingRequest >& request);

   //! overloaded methods from dia_ISystemSettingListener
   virtual void onSetSystemSettingMode ( dia_enSystemSettingMode mode, tDiaResult resultCode, tCookieType cookie );
   virtual void onSystemSettingProcessed ( dia_UID typeID, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie );
   virtual void onSystemSettingProcessed ( dia_UID typeID, dia_enSystemSettingLevel level, const dia_SystemSettingExtendedData& extData, tDiaResult resultCode, tCookieType cookie );

private:
   std::map<act_t,dia_RemoteControlRequestInfo*> mRemoteControlRequestRep;
   std::map<act_t,dia_SystemSettingRequestInfo*> mSystemSettingRequestRep;
};

} //namespace asf

#endif /* __INCLUDED_DIA_ASF_COMPONENT_SERVER__ */
