/*
 * dia_ASFComponentDiagClient.cpp
 *
 *  Created on: Dec 13, 2016
 *      Author: stc2hi
 */

#if 1
//Redefinition of new and delete when both OSAL and std::stl is used
#define __PLACEMENT_NEW_INLINE
#endif

#include "Midw_Diagnostics_FIProxy.h"

#ifndef __INCLUDED_DIA_COMMON_APPLICATION__
#include "common/framework/application/dia_common_application.h"
#endif

#ifndef __INCLUDED_DIA_SAFEATURE_DIAG_CLIENT__
#include <common/framework/sysadapters/dia_SAFeatureDiagClient.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT_DIAG_CLIENT__
#include "dia_ASFComponentDiagClient.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

using namespace Midw_Diagnostics_FI;

namespace asf {

//------------------------------------------------------------------------------

dia_ASFComponentDiagClient::dia_ASFComponentDiagClient()
{
   dia_tclFnctTrace oTrace("--> dia_ASFComponentDiagClient::dia_ASFComponentDiagClient");

   dia_Factory* pFactory = getInstanceOfFactory();
   if ( !pFactory )
   {
      DIA_TR_ERR("!!! Error: Failed to get pointer to global factory !!");
      return;
   }

   tDiaResult retCode = pFactory->requestInitializationLevel(DIA_EN_INITLEVEL_1);
   if ( retCode != DIA_SUCCESS )
   {
      DIA_TR_ERR("!!! Error: Failed to initialize DIA_EN_INITLEVEL_1 !!");
      return;
   }

   //
   // System Adapter object
   //

   // create the ASF system adapter object
   std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter(createSystemAdapter());
   ::boost::shared_ptr< Midw_Diagnostics_FIProxy > proxy = Midw_Diagnostics_FIProxy::createProxy("diagClientPort", *pSystemAdapter);

   //
   // Service Plugins
   //
   dia_SystemAdapterServicePluginASF< Midw_Diagnostics_FIProxy >* pSADiagService =
         dia_ASFComponent::createSystemAdapterServicePlugin<Midw_Diagnostics_FIProxy>(
            "DIA_SADiagSrv",
            proxy,
            pSystemAdapter);

   //
   // Feature Plugins
   //
   dia_SAFeatureDiagClient* pSAFeatureDiagClient =
         dia_ASFComponent::createSystemAdapterFeature<dia_SAFeatureDiagClient, Midw_Diagnostics_FIProxy>(pSADiagService);

   if ( pSAFeatureDiagClient )
   {
      if (assignInterfaceAndNotifier<dia_IDiagClient,dia_IDiagClientListener,dia_IDiagClientNotifier>(pSAFeatureDiagClient) != DIA_SUCCESS)
      {
         DIA_TR_ERR("!!! dia_ASFComponentDiagClient::dia_ASFComponentDiagClient => Error: assignInterfaceAndNotifier failed");
      }
   }

}
//------------------------------------------------------------------------------

dia_ASFComponentDiagClient::~dia_ASFComponentDiagClient()
{
}
//------------------------------------------------------------------------------

} //namespace asf

