/*
 * dia_PDXFile.cpp
 *
 *  Created on: 23.11.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_PDX_CATALOG__
#include <common/framework/odx/pdx/dia_PDXCatalog.h>
#endif

#ifndef __INCLUDED_DIA_PDX_FILE__
#include <common/framework/odx/pdx/dia_PDXFile.h>
#endif

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
PDXFile::evaluate ( void )
{
   dia::ScopeTrace oTrc("PDXFile::evaluate");

   if ( mpFile ) return DIA_SUCCESS;
   if ( !mpCatalog ) return DIA_FAILED;

   mpFile = new dia_File(std::string(mpCatalog->getRootFolder() + "/" + mFileName));
   if ( mpFile && mpFile->doesExist() )
   {
      DIA_TR_INF("  +--> CREATED FILE OBJECT \"%s\"", mpFile->getFileName());
      return DIA_SUCCESS;
   }

   delete mpFile;
   mpFile = 0;

   return DIA_FAILED;
}

void
PDXFile::setSuffix ( const std::string& fileName )
{
   dia::ScopeTrace oTrc("PDXFile::setSuffix");

   size_t found = fileName.find_last_of(".");
   mFileSuffix = fileName.substr(found+1);
   DIA_TR_INF("  +--> FILE SUFFIX = \"%s\"", mFileSuffix.c_str());
}


}
}



