/*!
 * \file       dia_PDXCatalog.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_CATALOG__
#define __INCLUDED_DIA_PDX_CATALOG__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PDX_TYPES__
#include <common/framework/odx/pdx/dia_PDXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class PDXABlock;
/**
 * \class   dia::odx::PDXCatalog
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class PDXCatalog
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(PDXCatalog);

public:
   PDXCatalog ( void ) {}

   void setRootFolder ( const std::string& pathName ) { mPath = pathName; }
   const std::string& getRootFolder ( void ) { return mPath; }

   tDiaResult addABlock ( PDXABlock& ablock );
   const std::list<PDXABlock*>& getABlocks ( void ) const { return mABlocks; }
   bool hasABlocks ( void ) const { return mABlocks.size() ? true : false; }

   tDiaResult evaluate ( void );

protected:
   std::string mPath;
   std::list<PDXABlock*> mABlocks;
};

}
}

#endif /* __INCLUDED_DIA_PDX_CATALOG__ */

