/*!
 * \file       dia_PDXCatalog.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/pdx/dia_PDXCatalog.h>

#ifndef __INCLUDED_DIA_PDX_ABLOCK__
#include <common/framework/odx/pdx/dia_PDXABlock.h>
#endif

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
PDXCatalog::evaluate ( void )
{
   dia::ScopeTrace oTrc("PDXCatalog::evaluate");

   if ( !hasABlocks() ) return DIA_FAILED;

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("    +--> NUMBER OF ABLOCKS = %zu",mABlocks.size());
   std::list<PDXABlock*>::iterator iter = mABlocks.begin();
   for ( ; iter != mABlocks.end(); ++iter )
   {
      DIA_TR_INF("    +--> EVALUATING ABLOCK \"%s\"",(*iter)->getShortName().c_str());
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

tDiaResult
PDXCatalog::addABlock ( PDXABlock& ablock )
{
   dia::ScopeTrace oTrc("PDXCatalog::addABlock");

   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   DIA_TR_INF("    +--> ADDING ABLOCK \"%s\"",ablock.getShortName().c_str());

   bool found = false;
   std::list<PDXABlock*>::iterator iter = mABlocks.begin();
   for ( ; iter != mABlocks.end(); ++iter )
   {
      if ( (*iter) == &ablock )
      {
         found = true;
         break;
      }
   }
   if ( !found )
   {
      mABlocks.push_back(&ablock);
      DIA_TR_INF("    +--> ADDED ABLOCK \"%s\"",ablock.getShortName().c_str());
      DIA_TR_INF("    +--> NUMBER OF ABLOCKS = %zu",mABlocks.size());
      retCode = DIA_SUCCESS;
   }
   else
   {
      DIA_TR_INF("    +--> ABLOCK \"%s\" NOT ADDED (ALREADY EXISTS)",ablock.getShortName().c_str());
      DIA_TR_INF("    +--> NUMBER OF ABLOCKS = %zu",mABlocks.size());
   }

   return retCode;
}

}
}
