/*!
 * \file       dia_PDXABlock.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_ABLOCK__
#define __INCLUDED_DIA_PDX_ABLOCK__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_PDX_TYPES__
#include <common/framework/odx/pdx/dia_PDXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class PDXCatalog;
class PDXFile;

/**
 * \class   dia::odx::PDXABlock
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class PDXABlock
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(PDXABlock);

public:
   PDXABlock ( void ) : mpCatalog(0), mUPD(gUnknownPdxABlockUPD) {}
   PDXABlock ( PDXCatalog& catalog ) : mpCatalog(&catalog), mUPD(gUnknownPdxABlockUPD) {}
   PDXABlock ( const std::string& upd, PDXCatalog& catalog ) : mpCatalog(&catalog), mUPD(upd) {}

   tDiaResult evaluate ( void );

   void setCatalog ( PDXCatalog& catalog ) { mpCatalog = &catalog; }

   const std::string& getUPD ( void ) const { return mUPD; }
   void setUPD ( const std::string& upd ) { mUPD = upd; }
   dia::UID getHashCodeOfUPD ( void ) { return dia_getHashCodeFromString(mUPD); }

   tDiaResult addFile ( PDXFile& file );
   const std::list<PDXFile*>& getFiles ( void ) const { return mFiles; }
   bool hasFiles ( void ) const { return mFiles.size() ? true : false; }

protected:
   PDXCatalog* mpCatalog;
   std::string mUPD;
   std::list<PDXFile*> mFiles;
};

}
}

#endif /* __INCLUDED_DIA_PDX_ABLOCK__ */
