/*!
 * \file       dia_PDXABlock.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_PDX_ABLOCK__
#include <common/framework/odx/pdx/dia_PDXABlock.h>
#endif

#include <common/framework/odx/pdx/dia_PDXFile.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
PDXABlock::evaluate ( void )
{
   dia::ScopeTrace oTrc("PDXABlock::::evaluate");

   if ( !hasFiles() ) return DIA_FAILED;

   tDiaResult retCode = DIA_SUCCESS;

   std::list<PDXFile*>::iterator iter = mFiles.begin();
   for ( ; iter != mFiles.end(); ++iter )
   {
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

tDiaResult
PDXABlock::addFile ( PDXFile& file )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<PDXFile*>::iterator iter = std::find(mFiles.begin(), mFiles.end(), (&file));
   if ( iter == mFiles.end() )
   {
      mFiles.push_back(&file);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}

