/*!
 * \file       dia_ODXSession.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_SESSION__
#define __INCLUDED_DIA_ODX_SESSION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ExpectedIdent;
class DataBlockRef;
class ODX;
class Mem;

/**
 * \class   dia::odx::Session
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class Session
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(Session);

public:
   Session ( const Mem& oParent ) : mpMem(&oParent), mpODX(0) {}
   Session ( const Mem& oParent , const ODX& oODX ) : mpMem(&oParent), mpODX(&oODX) {}
   virtual ~Session ( void );

   const Mem* getParent ( void ) const { return mpMem; }

   tDiaResult addExpectedIdent ( ExpectedIdent& ident );
   const std::list<ExpectedIdent*>& getExpectedIdents ( void ) const { return mExpectedIdents; }

   tDiaResult addDataBlockRef ( DataBlockRef& ref );
// tDiaResult removeDataBlockRef ( DataBlockRef& ref );
   const std::list<DataBlockRef*>& getDataBlockRefs ( void ) const { return mDataBlockRefs; }

   tDiaResult evaluate ( void );

protected:
   Session ( void );

protected:
   const Mem* mpMem;
   const ODX* mpODX;
   std::list<ExpectedIdent*> mExpectedIdents;
   std::list<DataBlockRef*> mDataBlockRefs;
};

}
}

#endif /* __INCLUDED_DIA_ODX_SESSION__ */
