/*!
 * \file       dia_ODXSession.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXSession.h>
#include <common/framework/odx/dia_ODXExpectedIdent.h>
#include <common/framework/odx/dia_ODXDataBlockRef.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

Session::~Session ( void )
{
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(ExpectedIdent,mExpectedIdents);
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(DataBlockRef,mDataBlockRefs);
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
Session::evaluate ( void )
{
   dia::ScopeTrace oTrc("Session::evaluate");

   DIA_TR_INF("        +--> EVALUATING SESSION \"%s\"",getShortName().c_str());

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("          +--> NUMBER OF EXPECTED IDENTS = %zu",mExpectedIdents.size());
   std::list<ExpectedIdent*>::iterator iter = mExpectedIdents.begin();
   for ( ; iter != mExpectedIdents.end(); ++iter )
   {
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   DIA_TR_INF("          +--> NUMBER OF DATABLOCK REFS = %zu",mDataBlockRefs.size());
   std::list<DataBlockRef*>::iterator iter2 = mDataBlockRefs.begin();
   for ( ; iter2 != mDataBlockRefs.end(); ++iter2 )
   {
      retCode = (*iter2)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

tDiaResult
Session::addExpectedIdent ( ExpectedIdent& ident )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<ExpectedIdent*>::iterator iter = std::find(mExpectedIdents.begin(), mExpectedIdents.end(), (&ident));
   if ( iter == mExpectedIdents.end() )
   {
      mExpectedIdents.push_back(&ident);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

tDiaResult
Session::addDataBlockRef ( DataBlockRef& ref )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<DataBlockRef*>::iterator iter = std::find(mDataBlockRefs.begin(), mDataBlockRefs.end(), (&ref));
   if ( iter == mDataBlockRefs.end() )
   {
      mDataBlockRefs.push_back(&ref);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}
