/*!
 * \file       dia_ODXNamedObject.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#define __INCLUDED_DIA_ODX_NAMED_OBJECT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

namespace dia {
namespace odx {

/**
 * \class   dia::odx::NamedObject
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(NamedObject);

public:
   NamedObject ( void ) : mShortName(gUnknownShortName), mLongName(gUnknownShortName), mID(gUnknownID), mOID(gUnknownOID) {}
   NamedObject ( const std::string& shortName, const std::string& longName = gUnknownShortName) : mShortName(shortName), mLongName(longName), mID(gUnknownID), mOID(gUnknownOID) {}

   const std::string& getShortName ( void ) const { return mShortName; }
   void setShortName ( const std::string& shortName ) { mShortName = shortName; }
   const std::string& getLongName ( void ) const { return mLongName; }
   void setLongName ( const std::string& longName ) { mLongName = longName; }
   const std::string& getID ( void ) const { return mID; }
   void setID ( const std::string& id ) { mID = id; }
   const std::string& getOID ( void ) const { return mOID; }
   void setOID ( const std::string& oid ) { mOID = oid; }

   dia::UID getHashCodeOfShortName ( void ) { return dia_getHashCodeFromString(mShortName); }
   dia::UID getHashCodeOfLongName ( void ) { return dia_getHashCodeFromString(mLongName); }
   dia::UID getHashCodeOfID ( void ) { return dia_getHashCodeFromString(mID); }
   dia::UID getHashCodeOfOID ( void ) { return dia_getHashCodeFromString(mOID); }

protected:
   std::string mShortName;
   std::string mLongName;
   std::string mID;
   std::string mOID;
};

}
}

#endif /* __INCLUDED_DIA_PDX__ */
