/*!
 * \file       dia_ODXMem.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_MEM__
#define __INCLUDED_DIA_ODX_MEM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class Session;
class DataBlock;
class FlashData;
class ODX;

/**
 * \class   dia::odx::Mem
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class Mem
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(Mem);

public:
   Mem ( void ) : mpODX(0) {}
   Mem ( const ODX& oODX ) : mpODX(&oODX) {}
   virtual ~Mem ( void );

   tDiaResult addSession ( Session& session );
// tDiaResult removeSession ( Session& session );
   const std::list<Session*>& getSessions ( void ) const { return mSessions; }
   bool hasSessions ( void ) const { return mSessions.size() ? true : false; }

   tDiaResult addDataBlock ( DataBlock& data );
// tDiaResult removeDataBlock ( DataBlock& data );
   const std::list<DataBlock*>& getDataBlocks ( void ) const { return mDataBlocks; }
   bool hasDataBlocks ( void ) const { return mDataBlocks.size() ? true : false; }

   tDiaResult addFlashData ( FlashData& data );
// tDiaResult removeFlashData ( FlashData& data );
   const std::list<FlashData*>& getFlashDatas ( void ) const { return mFlashDatas; }
   bool hasFlashDatas ( void ) const { return mFlashDatas.size() ? true : false; }

   tDiaResult evaluate ( void );

protected:
   const ODX* mpODX;
   std::list<Session*> mSessions;
   std::list<DataBlock*> mDataBlocks;
   std::list<FlashData*> mFlashDatas;
};

}
}

#endif /* __INCLUDED_DIA_ODX_MEM__ */
