/*!
 * \file       dia_ODXMem.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXMem.h>
#include <common/framework/odx/dia_ODXSession.h>
#include <common/framework/odx/dia_ODXDataBlock.h>
#include <common/framework/odx/dia_ODXFlashData.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

Mem::~Mem ( void )
{
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(Session,mSessions);
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(DataBlock,mDataBlocks);
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(FlashData,mFlashDatas);
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
Mem::evaluate ( void )
{
   dia::ScopeTrace oTrc("Mem::evaluate");

   if ( !hasSessions() ) return DIA_FAILED;
   if ( !hasDataBlocks() ) return DIA_FAILED;
   if ( !hasFlashDatas() ) return DIA_FAILED;

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("        +--> NUMBER OF SESSIONS = %zu",mSessions.size());
   std::list<Session*>::iterator iter = mSessions.begin();
   for ( ; iter != mSessions.end(); ++iter )
   {
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   if ( retCode != DIA_SUCCESS ) return DIA_FAILED;

   DIA_TR_INF("        +--> NUMBER OF DATA BLOCKS = %zu",mDataBlocks.size());
   std::list<DataBlock*>::iterator iter2 = mDataBlocks.begin();
   for ( ; iter2 != mDataBlocks.end(); ++iter2 )
   {
      retCode = (*iter2)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   if ( retCode != DIA_SUCCESS ) return DIA_FAILED;

   DIA_TR_INF("        +--> NUMBER OF FLASH DATAS = %zu",mFlashDatas.size());
   std::list<FlashData*>::iterator iter3 = mFlashDatas.begin();
   for ( ; iter3 != mFlashDatas.end(); ++iter3 )
   {
      retCode = (*iter3)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
Mem::addSession ( Session& session )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<Session*>::iterator iter = std::find(mSessions.begin(), mSessions.end(), (&session));
   if ( iter == mSessions.end() )
   {
      mSessions.push_back(&session);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

tDiaResult
Mem::addDataBlock ( DataBlock& data )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<DataBlock*>::iterator iter = std::find(mDataBlocks.begin(), mDataBlocks.end(), (&data));
   if ( iter == mDataBlocks.end() )
   {
      mDataBlocks.push_back(&data);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

tDiaResult
Mem::addFlashData ( FlashData& data )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<FlashData*>::iterator iter = std::find(mFlashDatas.begin(), mFlashDatas.end(), (&data));
   if ( iter == mFlashDatas.end() )
   {
      mFlashDatas.push_back(&data);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}
