/*!
 * \file       dia_ODXIdentValue.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_IDENT_VALUE__
#define __INCLUDED_DIA_ODX_IDENT_VALUE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

namespace dia {
namespace odx {

class ODX;

/**
 * \class   dia::odx::IdentValue
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class IdentValue
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(IdentValue);

public:
   IdentValue ( void ) : mpODX(0), mType(gUnknownIdentType) {}
   IdentValue ( const ODX& oODX ) : mpODX(&oODX), mType(gUnknownIdentType) {}

   tDiaResult evaluate ( void );

   const std::string& getTextValue ( void ) const { return mTextValue; }
   void setTextValue ( const std::string& textValue ) { mTextValue = textValue; }
   dia::UID getHashCodeOfTextValue ( void ) { return dia_getHashCodeFromString(mTextValue); }

   const std::string& getType ( void ) const { return mType; }
   void setType ( const std::string& type ) { mType = type; }
   dia::UID getHashCodeOfType ( void ) { return dia_getHashCodeFromString(mType); }

protected:
   const ODX* mpODX;
   std::string mTextValue;
   std::string mType;
};

}
}

#endif /* __INCLUDED_DIA_ODX_IDENT_VALUE__ */
