/*!
 * \file       dia_ODXFlashDataRef.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA_REF__
#define __INCLUDED_DIA_ODX_FLASH_DATA_REF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_ID_REF__
#include <common/framework/odx/dia_ODXIdRef.h>
#endif

namespace dia {
namespace odx {

class ODX;
class DataBlock;
class FlashData;

/**
 * \class   dia::odx::FlashDataRef
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class FlashDataRef
   : public IdRef
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(FlashDataRef);

public:
   FlashDataRef ( void ) : mpODXDataBlock(0), mpODX(0), mpFlashData(0) {}
   FlashDataRef ( const DataBlock& oODXDataBlock, const ODX& oODX ) : mpODXDataBlock(&oODXDataBlock), mpODX(&oODX), mpFlashData(0) {}

   const DataBlock* getParent ( void ) const { return mpODXDataBlock; }
   const FlashData* getFlashData ( void ) const { return mpFlashData; }

   tDiaResult evaluate ( void );

protected:
   const DataBlock* mpODXDataBlock;
   const ODX* mpODX;
   const FlashData* mpFlashData;
};

}
}

#endif /* __INCLUDED_DIA_ODX_FLASH_DATA_REF__ */
