/*
 * dia_ODXFlashDataExtern.cpp
 *
 *  Created on: 23.11.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

#ifndef __INCLUDED_DIA_ODX__
#include <common/framework/odx/dia_ODX.h>
#endif

#ifndef __INCLUDED_DIA_ODX_FLASH_DATA_EXTERN__
#include <common/framework/odx/dia_ODXFlashDataExtern.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include "common/framework/utils/dia_utilities.h"
#endif

#include <limits> //needed by std::numeric_limits

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
FlashDataExtern::evaluate ( void )
{
   dia::ScopeTrace oTrc("FlashDataExtern::evaluate");

   if ( mpFile ) return DIA_SUCCESS;
   if ( !mpODX ) return DIA_FAILED;

   DIA_TR_INF("          +--> EVALUATING FLASH DATA \"%s\" (EXTERN)",getShortName().c_str());

   tDiaResult retCode = DIA_FAILED;

   mpFile = new dia_File(std::string(mpODX->getRootFolder()) + "/" + mDataFileName);
   if ( mpFile && mpFile->doesExist() )
   {
      DIA_TR_INF("            +--> CREATED FILE OBJECT \"%s\"", mpFile->getFileName());
      mSizeOfData = mpFile->getSize();
      retCode = DIA_SUCCESS;
   }
   else
   {
      delete mpFile;
      mpFile = 0;
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
FlashDataExtern::getData ( std::vector<tU8>& data )
{
   dia::ScopeTrace oTrc("FlashDataExtern::getData");

   DIA_TR_INF("FlashDataExtern::getData file name is \"%s\"", getShortName().c_str());

   tDiaResult retVal = DIA_FAILED;

   if (NULL==mpFile)
   {
      DIA_TR_ERR("FlashDataExtern::getData Null ptr for file \"%s\".", getShortName().c_str());
      return DIA_E_FILE_DOES_NOT_EXIST;
   }

   if (false==mpFile->doesExist())
   {
      DIA_TR_ERR("FlashDataExtern::getData File \"%s\" doesn't exist.", getShortName().c_str());
      return DIA_E_FILE_DOES_NOT_EXIST;
   }

   tDiaResult retOpen = mpFile->open("rb+");
   if ( DIA_SUCCESS != retOpen )
   {
      DIA_TR_ERR("### FlashDataExtern::getData open failed, error code 0x%08X. File \"%s\".", retOpen, getShortName().c_str());
      return DIA_E_FILE_OPEN_FAILED;
   }

   do
   {
      tU32 expDataSizeInBytes = mpFile->getSize();
      if (std::numeric_limits<tU32>::max()==expDataSizeInBytes)
      {
         DIA_TR_ERR("FlashDataExtern::getData Size of file unknown. File \"%s\".", getShortName().c_str());
         retVal = DIA_E_FILE_OPEN_FAILED;
         break;
      }

      DIA_TR_INF("FlashDataExtern::getData File size is %d bytes.", expDataSizeInBytes);

      data.clear();
      data.reserve(expDataSizeInBytes);
      data.resize(expDataSizeInBytes);

      size_t currNumOfBytesRead = expDataSizeInBytes;
      tDiaResult retRead = mpFile->rawRead(&data[0], &currNumOfBytesRead);
      if ( (DIA_SUCCESS!=retRead) || (0==currNumOfBytesRead) )
      {
         DIA_TR_ERR("### FlashDataExtern::getData Read impossible (retRead=0x%08X, numOfByte %zu). File \"%s\".", retRead, currNumOfBytesRead, getShortName().c_str());
         retVal = DIA_E_FILE_READ_FAILED;
         break;
      }

      if (((size_t)expDataSizeInBytes)!=currNumOfBytesRead)
      {
         DIA_TR_ERR("### FlashDataExtern::getData Length of read data is wrong (exp=%u,curr=%zu).", expDataSizeInBytes, currNumOfBytesRead);
         retVal = DIA_E_FILE_READ_FAILED;
         break;
      }

      retVal = DIA_SUCCESS;
   }
   while(0);

   tDiaResult retClose = mpFile->close();
   if (DIA_SUCCESS!=retClose)
   {
      DIA_TR_ERR("FlashDataExtern::getData File close failed, error code 0x%08X. File \"%s\".", retClose, getShortName().c_str());
      return DIA_E_FILE_READ_FAILED;
   }

   if (DIA_SUCCESS==retVal)
   {
      DIA_TR_INF("FlashDataExtern::getData %zu bytes read from file",data.size());
      DIA_TR_INF("FlashDataExtern::getData Data: '%s'", dia::utils::bin2str((tU8*) (&data[0]),(int) data.size(),' ').c_str());
   }
   else
   {
      DIA_TR_ERR("### FlashDataExtern::getData failed with error code 0x%08X.", retVal);
   }

   return retVal;
}

}
}

