/*!
 * \file       dia_ODXNamedObject.h
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_ODX_FLASH__
#define __INCLUDED_DIA_ODX_FLASH__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ODX_TYPES__
#include <common/framework/odx/dia_ODXTypes.h>
#endif

#ifndef __INCLUDED_DIA_ODX_NAMED_OBJECT__
#include <common/framework/odx/dia_ODXNamedObject.h>
#endif

namespace dia {
namespace odx {

class ODX;
class EcuMem;

/**
 * \class   dia::odx::Flash
 *
 * \brief   TBD
 *
 * \ingroup diaCoreODX
 */

class Flash
   : public NamedObject
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(Flash);

public:
   Flash ( void ) : mpODX(0) {}
   Flash ( const ODX& oODX ) : mpODX(&oODX) {}
   virtual ~Flash ( void );

   void setODX ( const ODX& oODX ) { mpODX = &oODX; }

   tDiaResult addEcuMem ( EcuMem& ecuMem );
   const std::list<EcuMem*>& getEcuMems ( void ) const { return mEcuMems; }
   bool hasEcuMems ( void ) const { return mEcuMems.size() ? true : false; }

   tDiaResult evaluate ( void );

protected:
   const ODX* mpODX;
   std::list<EcuMem*> mEcuMems;
};

}
}

#endif /* __INCLUDED_DIA_ODX_FLASH__ */
