/*!
 * \file       dia_ODXFlash.cpp
 *
 * \brief      TBD
 *
 * \details    TBD
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreODX
 *
 * \copyright  (c) 2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include <common/framework/odx/dia_ODXFlash.h>
#include <common/framework/odx/dia_ODXEcuMem.h>

namespace dia {
namespace odx {

//---------------------------------------------------------------------------------------------------------------------

Flash::~Flash ( void )
{
   DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(EcuMem,mEcuMems);
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
Flash::evaluate ( void )
{
   dia::ScopeTrace oTrc("ODXFlash::evaluate");

   if ( !hasEcuMems() ) return DIA_FAILED;

   tDiaResult retCode = DIA_SUCCESS;

   DIA_TR_INF("    +--> NUMBER OF ECUMEMS = %zu",mEcuMems.size());
   std::list<EcuMem*>::iterator iter = mEcuMems.begin();
   for ( ; iter != mEcuMems.end(); ++iter )
   {
      DIA_TR_INF("    +--> EVALUATING ECUMEM \"%s\"",(*iter)->getShortName().c_str());
      retCode = (*iter)->evaluate();
      if ( retCode != DIA_SUCCESS ) break;
   }

   return retCode;
}

tDiaResult
Flash::addEcuMem ( EcuMem& ecuMem )
{
   tDiaResult retCode = DIA_E_ALREADY_EXISTS;

   std::list<EcuMem*>::iterator iter = std::find(mEcuMems.begin(), mEcuMems.end(), (&ecuMem));
   if ( iter == mEcuMems.end() )
   {
      mEcuMems.push_back(&ecuMem);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

}
}


