///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SystemAdapterFSM.cpp
//
// Generated by SMC 4.6.1 (C++ State Pattern Code Generator)
//
// Command Line Arguments:
//
//   -c dia_SystemAdapterFSM.fsm
//   --protected_interface
//   --use_factory_method
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_SYSTEMADAPTERFSM__
#include "dia_SystemAdapterFSM.h"
#endif

namespace dia_SystemAdapterFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRegistrationID ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
//
// Class: NormalState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class NormalState
   : public FsmState
{
public:
   //! default constructor
   NormalState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRegistrationID ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* NormalState::mStateName = "Normal";

///////////////////////////////////////////////////////////////////////////////
//
// Class: OffState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class OffState
   : public FsmState
{
public:
   //! default constructor
   OffState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* OffState::mStateName = "Off";

///////////////////////////////////////////////////////////////////////////////
//
// Class: PauseState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class PauseState
   : public FsmState
{
public:
   //! default constructor
   PauseState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* PauseState::mStateName = "Pause";

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evMessage ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evNormal ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evOff ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evPause ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void* pInitArg=0 );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    IdleState oIdleState;
    NormalState oNormalState;
    OffState oOffState;
    PauseState oPauseState;
    TopLevelState oTopLevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evMessage ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evMessage *** 
}

void
FsmState::evNormal ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evNormal *** 
}

void
FsmState::evOff ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evOff *** 
}

void
FsmState::evPause ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evPause *** 
}

void
FsmState::evRegistrationID ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRegistrationID *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::evMessage ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmUnknownMessage(pArg);
   // this is an internal transition
}

void
IdleState::evNormal ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNormalState,pArg);
}

void
IdleState::evOff ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oOffState,pArg);
}

void
IdleState::evPause ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oPauseState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: NormalState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

NormalState::NormalState ( void )
{}

void
NormalState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmRegisterServices(pArg);
   s.vFsmNormalModeReached(pArg);
}

void
NormalState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmUnregisterServices(pArg);
}

void
NormalState::evMessage ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmProcessMessage(pArg);
   // this is an internal transition
}

void
NormalState::evNormal ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
NormalState::evOff ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oOffState,pArg);
}

void
NormalState::evPause ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oPauseState,pArg);
}

void
NormalState::evRegistrationID ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateRegistrationIDs(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: OffState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

OffState::OffState ( void )
{}

void
OffState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmOffModeReached(pArg);
}

void
OffState::evMessage ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmUnknownMessage(pArg);
   // this is an internal transition
}

void
OffState::evNormal ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNormalState,pArg);
}

void
OffState::evOff ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
OffState::evPause ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oPauseState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: PauseState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

PauseState::PauseState ( void )
{}

void
PauseState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmPauseModeReached(pArg);
}

void
PauseState::evMessage ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmUnknownMessage(pArg);
   // this is an internal transition
}

void
PauseState::evNormal ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNormalState,pArg);
}

void
PauseState::evOff ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oOffState,pArg);
}

void
PauseState::evPause ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evMessage ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmUnknownMessage(pArg);
   // this is an internal transition
}

void
TopLevelState::evNormal ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oNormalState,pArg);
}

void
TopLevelState::evOff ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oOffState,pArg);
}

void
TopLevelState::evPause ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oPauseState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour, void* pInitArg )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init(pInitArg)) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void* pInitArg )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init(pInitArg) )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void* pInitArg )
{
    oIdleState.initState(&oTopLevelState);
    oNormalState.initState(&oTopLevelState);
    oOffState.initState(&oTopLevelState);
    oPauseState.initState(&oTopLevelState);
    oTopLevelState.initSuperState(0, &oIdleState, false);

    setState(oTopLevelState,pInitArg);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evMessage:
            if ( mpState ) mpState->evMessage(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evNormal:
            if ( mpState ) mpState->evNormal(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evOff:
            if ( mpState ) mpState->evOff(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evPause:
            if ( mpState ) mpState->evPause(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRegistrationID:
            if ( mpState ) mpState->evRegistrationID(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evMessage",
      "evNormal",
      "evOff",
      "evPause",
      "evRegistrationID",
   };

   return eventNames[event];
}


} // namespace
