///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SessionControlFSM.h
//
// Generated by SMC 4.1.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SESSIONCONTROLFSM__
#define __INCLUDED_DIA_SESSIONCONTROLFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_SessionControlFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evTimeout,
    evChangeSession,
    evSessionActive,
    evSessionInactive,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{
    friend class EnteringSessionState;
    friend class LeavingSessionState;
    friend class NoSessionActiveState;
    friend class SessionActiveState;
    friend class TopLevelState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vFsmReset ( void* pArg ) = 0;
    virtual void vFsmEnterSession ( void* pArg ) = 0;
    virtual void vFsmSetActiveSession ( void* pArg ) = 0;
    virtual void vFsmNotifySessionChange ( void* pArg ) = 0;
    virtual void vFsmSetLastSession ( void* pArg ) = 0;
    virtual void vFsmLeaveSession ( void* pArg ) = 0;

    // FSM guards
    virtual bool bIsSessionChangeRequired ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SessionControlFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
