///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SelftestControllerFSM.h
//
// Generated by SMC 4.1.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SELFTESTCONTROLLERFSM__
#define __INCLUDED_DIA_SELFTESTCONTROLLERFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/depricated/dia_common.h"
#endif

namespace dia_SelftestControllerFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
    evUnknown = 0,
    evError,
    evRequest,
    evRequestResult,
    evStop,
    evConfirmedSuccess,
    evConfirmedFailure,
    evStartFailed,
    evResultReady,
    evTimeout,
    evRequestResultFailed,
    evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
    friend class FinishedState;
    friend class NotStartedState;
    friend class RequestedState;
    friend class StartedState;
    friend class TopLevelState;
    friend class FsmBody;

public:
    virtual ~FsmBehaviour ( void ) {}

protected:
    // FSM actions
    virtual void vFsmHandleError ( void* pArg ) = 0;
    virtual void vFsmRequestResultFailed ( void* pArg ) = 0;
    virtual void vFsmStopFailed ( void* pArg ) = 0;
    virtual void vFsmRequestSelftest ( void* pArg ) = 0;
    virtual void vFsmRequestSuccess ( void* pArg ) = 0;
    virtual void vFsmRequestFailure ( void* pArg ) = 0;
    virtual void vFsmStartFailed ( void* pArg ) = 0;
    virtual void vFsmRequestResultInProgress ( void* pArg ) = 0;
    virtual void vFsmStopSelftest ( void* pArg ) = 0;
    virtual void vFsmStopDone ( void* pArg ) = 0;
    virtual void vFsmSelftestFailed ( void* pArg ) = 0;
    virtual void vFsmSelftestDone ( void* pArg ) = 0;
    virtual void vFsmRequestResult ( void* pArg ) = 0;

};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SelftestControllerFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! setup and initialize the state machine
    void init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
