///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SecurityLevelFSM.h
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SECURITYLEVELFSM__
#define __INCLUDED_DIA_SECURITYLEVELFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_SecurityLevelFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evActivate,
   evActivationConfirmed,
   evActivationFailed,
   evCheckKeyCtrl,
   evDeactivate,
   evKeyReceived,
   evKeyTimeout,
   evLockTimeExpired,
   evNumOfAttemptsExceeded,
   evOnKeyValidationDone,
   evOnSeedAvailable,
   evOperationModeUpdate,
   evReset,
   evSeedRequested,
   evSessionChanged,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class EvaluatingKeyState;
   friend class GeneratingSeedState;
   friend class IdleState;
   friend class RunningSeedAndKeyPolicyState;
   friend class SecLevelActiveState;
   friend class SecLevelActiveNoRestrictionState;
   friend class SecLevelActiveRestrictedToSessionState;
   friend class SecLevelInitializeState;
   friend class SecLevelLockedState;
   friend class SecLevelNotActiveState;
   friend class SecLevelRunningState;
   friend class SecurityAccessDisabledState;
   friend class SecurityAccessEnabledState;
   friend class TopLevelState;
   friend class WaitingForKeyState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmActivate ( void* pArg ) = 0;
   virtual void vFsmActivateAtStartup ( void* pArg ) = 0;
   virtual void vFsmCalculateSeed ( void* pArg ) = 0;
   virtual void vFsmCopyKeyCtrlFromNvm ( void* pArg ) = 0;
   virtual void vFsmDeactivate ( void* pArg ) = 0;
   virtual void vFsmEvaluateOperationMode ( void* pArg ) = 0;
   virtual void vFsmHandleActivation ( void* pArg ) = 0;
   virtual void vFsmHandleFailedActivation ( void* pArg ) = 0;
   virtual void vFsmInitializeSecurityLevel ( void* pArg ) = 0;
   virtual void vFsmInitializeSeedAndKeyPolicy ( void* pArg ) = 0;
   virtual void vFsmInvalidAttempt ( void* pArg ) = 0;
   virtual void vFsmLock ( void* pArg ) = 0;
   virtual void vFsmSaveKeyCtrlToNvm ( void* pArg ) = 0;
   virtual void vFsmSendKeyAccepted ( void* pArg ) = 0;
   virtual void vFsmSendKeyNotAccepted ( void* pArg ) = 0;
   virtual void vFsmSendSeed ( void* pArg ) = 0;
   virtual void vFsmSendSeedWhenActive ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_InvalidKey ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_InvalidLevel ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_RequestSequence ( void* pArg ) = 0;
   virtual void vFsmSetErrCode_RequiredTimeDelayNotExpired ( void* pArg ) = 0;
   virtual void vFsmSetRemainingLockTime ( void* pArg ) = 0;
   virtual void vFsmSimulateCalcSeed ( void* pArg ) = 0;
   virtual void vFsmSimulateKeyAccepted ( void* pArg ) = 0;
   virtual void vFsmSimulateSeedResponse ( void* pArg ) = 0;
   virtual void vFsmStartKeyTimer ( void* pArg ) = 0;
   virtual void vFsmStopKeyTimer ( void* pArg ) = 0;
   virtual void vFsmUnlock ( void* pArg ) = 0;
   virtual void vFsmValidateKey ( void* pArg ) = 0;

   // FSM guards
   virtual bool isKeyInvalid ( void* pArg ) = 0;
   virtual bool isLevelInvalid ( void* pArg ) = 0;
   virtual bool isLockRequired ( void* pArg ) = 0;
   virtual bool isSessionControlled ( void* pArg ) = 0;
   virtual bool isSimulationEnabled ( void* pArg ) = 0;
   virtual bool needToRunSeedKeyPolicy ( void* pArg ) = 0;
   virtual bool wasSeedRequested ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SecurityLevelFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
