///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SCCManagerFSM.h
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_SCCMANAGERFSM__
#define __INCLUDED_DIA_SCCMANAGERFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_SCCManagerFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evReconnect,
   evRequestStatusActive,
   evRequestStatusInactive,
   evReset,
   evStatusUpdate,
   evTimeout,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ActivatingState;
   friend class ActiveState;
   friend class DeactivatingState;
   friend class FinalState;
   friend class InactiveState;
   friend class InitializingState;
   friend class ReconnectingState;
   friend class ToplevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmFinalize ( void* pArg ) = 0;
   virtual void vFsmOnActive ( void* pArg ) = 0;
   virtual void vFsmOnInactive ( void* pArg ) = 0;
   virtual void vFsmOnInitializing ( void* pArg ) = 0;
   virtual void vFsmOnReconnecting ( void* pArg ) = 0;
   virtual void vFsmRetryReconnect ( void* pArg ) = 0;
   virtual void vFsmSendStatusActive ( void* pArg ) = 0;
   virtual void vFsmSendStatusInactive ( void* pArg ) = 0;
   virtual void vFsmStartReconnection ( void* pArg ) = 0;
   virtual void vFsmStartTimer ( void* pArg ) = 0;
   virtual void vFsmStopTimer ( void* pArg ) = 0;
   virtual void vFsmTriggerSystemReset ( void* pArg ) = 0;

   // FSM guards
   virtual bool isActive ( void* pArg ) = 0;
   virtual bool isActiveRequested ( void* pArg ) = 0;
   virtual bool isInactive ( void* pArg ) = 0;
   virtual bool isMaxRetriesReached ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_SCCManagerFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
