///////////////////////////////////////////////////////////////////////////////
//
// File: dia_SAFeatureAuthorizationLevelFSM.cpp
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_SAFEATUREAUTHORIZATIONLEVELFSM__
#include "dia_SAFeatureAuthorizationLevelFSM.h"
#endif

namespace dia_SAFeatureAuthorizationLevelFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evDeviceLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevel ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevelChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevelChangeIndication ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWarning ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ActiveState
   : public FsmSuperState
{
public:
   //! default constructor
   ActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWarning ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveState::mStateName = "Active";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InitializingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class InitializingState
   : public FsmState
{
public:
   //! default constructor
   InitializingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevel ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWarning ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* InitializingState::mStateName = "Initializing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class WaitingState
   : public FsmState
{
public:
   //! default constructor
   WaitingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDeviceLock ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evError ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evKeyValidated ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevel ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevelChanged ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evLevelChangeIndication ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evSeedReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evWarning ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* WaitingState::mStateName = "Waiting";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActiveState oActiveState;
    IdleState oIdleState;
    InitializingState oInitializingState;
    TopLevelState oTopLevelState;
    WaitingState oWaitingState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evDeviceLock ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDeviceLock *** 
}

void
FsmState::evError ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evError *** 
}

void
FsmState::evKeyValidated ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evKeyValidated *** 
}

void
FsmState::evLevel ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evLevel *** 
}

void
FsmState::evLevelChanged ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evLevelChanged *** 
}

void
FsmState::evLevelChangeIndication ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evLevelChangeIndication *** 
}

void
FsmState::evSeedReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evSeedReceived *** 
}

void
FsmState::evStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStart *** 
}

void
FsmState::evStop ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStop *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

void
FsmState::evWarning ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evWarning *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ActiveState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ActiveState::ActiveState ( void )
{}

void
ActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartMonitoring(pArg);
}

void
ActiveState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vStopMonitoring(pArg);
}

void
ActiveState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmHandleError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ActiveState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ActiveState::evWarning ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleWarning(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
}

void
IdleState::evError ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleError(pArg);
   // this is an internal transition
}

void
IdleState::evStart ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActiveState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: InitializingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

InitializingState::InitializingState ( void )
{}

void
InitializingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStartInitTimer(pArg);
   s.vFsmRequestLevel(pArg);
}

void
InitializingState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopInitTimer(pArg);
}

void
InitializingState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oActiveState.exit(b,s,pArg);
   // transition Actions
   s.vFsmHandleError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
InitializingState::evLevel ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmStoreLevel(pArg);
   b.setState(b.oWaitingState,pArg);
}

void
InitializingState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.oActiveState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
InitializingState::evTimeout ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRequestLevel(pArg);
   // this is an internal transition
}

void
InitializingState::evWarning ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleWarning(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleError(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

WaitingState::WaitingState ( void )
{}

void
WaitingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmNotifyLevel(pArg);
}

void
WaitingState::evDeviceLock ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmNotifyDeviceLock(pArg);
   // this is an internal transition
}

void
WaitingState::evError ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oActiveState.exit(b,s,pArg);
   // transition Actions
   s.vFsmHandleError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
WaitingState::evKeyValidated ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmNotifyKeyValidationResult(pArg);
   // this is an internal transition
}

void
WaitingState::evLevel ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStoreLevel(pArg);
   s.vFsmNotifyLevel(pArg);
   // this is an internal transition
}

void
WaitingState::evLevelChanged ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmStoreLevel(pArg);
   s.vFsmNotifyLevelChange(pArg);
   s.vFsmNotifyLevel(pArg);
   // this is an internal transition
}

void
WaitingState::evLevelChangeIndication ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmNotifyLevelChangeIndication(pArg);
   // this is an internal transition
}

void
WaitingState::evSeedReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmNotifySeed(pArg);
   // this is an internal transition
}

void
WaitingState::evStop ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oActiveState.exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
WaitingState::evWarning ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmHandleWarning(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActiveState.initSuperState(&oTopLevelState, &oInitializingState, false);
    oIdleState.initState(&oTopLevelState);
    oInitializingState.initState(&oActiveState);
    oTopLevelState.initSuperState(0, &oIdleState, false);
    oWaitingState.initState(&oActiveState);

    setState(oTopLevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evDeviceLock:
            if ( mpState ) mpState->evDeviceLock(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evError:
            if ( mpState ) mpState->evError(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evKeyValidated:
            if ( mpState ) mpState->evKeyValidated(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evLevel:
            if ( mpState ) mpState->evLevel(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evLevelChanged:
            if ( mpState ) mpState->evLevelChanged(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evLevelChangeIndication:
            if ( mpState ) mpState->evLevelChangeIndication(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evSeedReceived:
            if ( mpState ) mpState->evSeedReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStart:
            if ( mpState ) mpState->evStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStop:
            if ( mpState ) mpState->evStop(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evWarning:
            if ( mpState ) mpState->evWarning(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evDeviceLock",
      "evError",
      "evKeyValidated",
      "evLevel",
      "evLevelChanged",
      "evLevelChangeIndication",
      "evSeedReceived",
      "evStart",
      "evStop",
      "evTimeout",
      "evWarning",
   };

   return eventNames[event];
}


} // namespace
