///////////////////////////////////////////////////////////////////////////////
//
// File: dia_RoutineCtrlSCCSecuritySettingsFSM.h
//
// Generated by SMC 4.4.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_ROUTINECTRLSCCSECURITYSETTINGSFSM__
#define __INCLUDED_DIA_ROUTINECTRLSCCSECURITYSETTINGSFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_RoutineCtrlSCCSecuritySettingsFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evGetResults,
   evIdle,
   evReconnected,
   evStart,
   evSystemStateUpdate,
   evTerminated,
   evTimeout,
   evUpdateApplicationNotStarted,
   evUpdateApplicationStarted,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class DoneState;
   friend class ExecuteState;
   friend class IdleState;
   friend class RunningState;
   friend class SettingSystemStateState;
   friend class StartingState;
   friend class ToplevelState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmCollectResults ( void* pArg ) = 0;
   virtual void vFsmEvaluateResults ( void* pArg ) = 0;
   virtual void vFsmFinalizeSystemStateSetting ( void* pArg ) = 0;
   virtual void vFsmGetSystemState ( void* pArg ) = 0;
   virtual void vFsmRequestSystemState ( void* pArg ) = 0;
   virtual void vFsmReset ( void* pArg ) = 0;
   virtual void vFsmSendResponse ( void* pArg ) = 0;
   virtual void vFsmSetError_AppStartFailed ( void* pArg ) = 0;
   virtual void vFsmSetError_Timeout ( void* pArg ) = 0;
   virtual void vFsmSetResultRunning ( void* pArg ) = 0;
   virtual void vFsmSetResultsInProgress ( void* pArg ) = 0;
   virtual void vFsmSetResultsNotAvailable ( void* pArg ) = 0;
   virtual void vFsmStartReconnection ( void* pArg ) = 0;
   virtual void vFsmStartUpdateApplication ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmIsRequiredSystemState ( void* pArg ) = 0;
   virtual bool bFsmIsRunning ( void* pArg ) = 0;
   virtual bool bFsmNeedToRequestSystemState ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_RoutineCtrlSCCSecuritySettingsFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
