///////////////////////////////////////////////////////////////////////////////
//
// File: dia_RemoteControlFSM.cpp
//
// Generated by SMC 4.5.1 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_REMOTECONTROLFSM__
#include "dia_RemoteControlFSM.h"
#endif

namespace dia_RemoteControlFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

const unsigned int MAX_DEFERRED_EVENTS = 25;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions
   virtual void evCheckCompletion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActivatingState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ActivatingState
   : public FsmState
{
public:
   //! default constructor
   ActivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckCompletion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ActivatingState::mStateName = "Activating";

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class ActiveState
   : public FsmState
{
public:
   //! default constructor
   ActiveState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ActiveState::mStateName = "Active";

///////////////////////////////////////////////////////////////////////////////
//
// Class: DeactivatingState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class DeactivatingState
   : public FsmState
{
public:
   //! default constructor
   DeactivatingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckCompletion ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* DeactivatingState::mStateName = "Deactivating";

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evStart ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evStop ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Concrete state of FSM
//
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ActivatingState oActivatingState;
    ActiveState oActiveState;
    DeactivatingState oDeactivatingState;
    IdleState oIdleState;
    TopLevelState oTopLevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evCheckCompletion ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evCheckCompletion ***
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived ***
}

void
FsmState::evStart ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStart ***
}

void
FsmState::evStop ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evStop ***
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout ***
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);

   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }

   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActivatingState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ActivatingState::ActivatingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ActivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmPrepare(pArg);
   s.vFsmActivatePlugin(pArg);
}

void
ActivatingState::evCheckCompletion ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsActivationFailed(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oDeactivatingState,pArg);
    }
    else if ( s.bIsActivationComplete(pArg) )
   {
        // transition Actions
        s.vFsmSetActivatedPlugin(pArg);
        s.vFsmResultReady(pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oActiveState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSetActivatedPlugin(pArg);
   s.vFsmSetNextPlugin(pArg);
   s.vFsmActivatePlugin(pArg);
   // this is an internal transition
    }
}

void
ActivatingState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponse(pArg);
   // trigger events
   FsmEvent event = dia_RemoteControlFSM::evUnknown;

   event = dia_RemoteControlFSM::evCheckCompletion; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ActivatingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_Timeout(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oDeactivatingState,pArg);
}

void
ActivatingState::evStop( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_RemoteControlFSM::evStop;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: ActiveState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

ActiveState::ActiveState ( void )
{}

void
ActiveState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmSetModeON(pArg);
   s.vFsmNotify(pArg);
}

void
ActiveState::evStart ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_OK(pArg);
   s.vFsmResultReady(pArg);
   s.vFsmNotify(pArg);
   // this is an internal transition
}

void
ActiveState::evStop ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oDeactivatingState,pArg);
}

void
ActiveState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_Timeout(pArg);
   b.setState(b.oDeactivatingState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: DeactivatingState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

DeactivatingState::DeactivatingState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
DeactivatingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmPrepareDeactivation(pArg);
   s.vFsmDeactivatePlugin(pArg);
}

void
DeactivatingState::evCheckCompletion ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bIsDeactivationComplete(pArg) )
   {
        // transition Actions
        s.vFsmResultReady(pArg);
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oIdleState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSetNextDeactivationPlugin(pArg);
   s.vFsmDeactivatePlugin(pArg);
   // this is an internal transition
    }
}

void
DeactivatingState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResponse(pArg);
   // trigger events
   FsmEvent event = dia_RemoteControlFSM::evUnknown;

   event = dia_RemoteControlFSM::evCheckCompletion; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
DeactivatingState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_Timeout(pArg);
   b.setState(b.oDeactivatingState,pArg);
}

void
DeactivatingState::evStart( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_RemoteControlFSM::evStart;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: IdleState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmReset(pArg);
   s.vFsmSetModeOFF(pArg);
   s.vFsmNotify(pArg);
}

void
IdleState::evStart ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oActivatingState,pArg);
}

void
IdleState::evStop ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_OK(pArg);
   s.vFsmResultReady(pArg);
   s.vFsmNotify(pArg);
   // this is an internal transition
}

void
IdleState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
//
// Class: TopLevelState
//
// Implementation of concrete FSM state
//
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSetErrCode_Timeout(pArg);
   b.setState(b.oDeactivatingState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;

   mpBody = new FsmBody();

   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }

   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oActivatingState.initState(&oTopLevelState);
    oActiveState.initState(&oTopLevelState);
    oDeactivatingState.initState(&oTopLevelState);
    oIdleState.initState(&oTopLevelState);
    oTopLevelState.initSuperState(0, &oIdleState, false);

    setState(oTopLevelState,0);

    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evCheckCompletion:
            if ( mpState ) mpState->evCheckCompletion(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStart:
            if ( mpState ) mpState->evStart(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStop:
            if ( mpState ) mpState->evStop(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event )
{
   static const char* eventNames[evCount] = {
      "evUnknown",
      "evCheckCompletion",
      "evResponseReceived",
      "evStart",
      "evStop",
      "evTimeout",
   };

   return eventNames[event];
}


} // namespace
