///////////////////////////////////////////////////////////////////////////////
//
// File: dia_MultipleReadFSM.cpp
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_MULTIPLEREADFSM__
#include "dia_MultipleReadFSM.h"
#endif
#include <boost/any.hpp>

namespace dia_MultipleReadFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evCheckCompletion ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evStartProcessing ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessingState
   : public FsmState
{
public:
   //! default constructor
   ProcessingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evCheckCompletion ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

protected:
   static const char* mStateName;
};

const char* ProcessingState::mStateName = "Processing";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, boost::any& pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, boost::any& pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, boost::any& arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event,  boost::any& arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, boost::any& pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    IdleState oIdleState;
    ProcessingState oProcessingState;
    TopLevelState oTopLevelState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    boost::any mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evCheckCompletion ( FsmBody& /* b */, FsmBehaviour& /* s */,boost::any& /* pArg */ )
{
    // *** Ignoring Event evCheckCompletion *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
    // *** Ignoring Event evResponseReceived *** 
}

void
FsmState::evStartProcessing ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
    // *** Ignoring Event evStartProcessing *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, boost::any& pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, boost::any& pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::entry ( FsmBody& /* b */, FsmBehaviour& s, boost::any& pArg )
{
   s.vFsmReset(pArg);
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, boost::any& /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evStartProcessing ( FsmBody& b, FsmBehaviour& /* s */, boost::any& pArg )
{
   b.setState(b.oProcessingState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessingState::ProcessingState ( void )
{}

void
ProcessingState::entry ( FsmBody& /* b */, FsmBehaviour& s, boost::any& pArg )
{
   s.vFsmPrepareProcessing(pArg);
   s.vFsmStartProcessingTimer(pArg);
   s.vFsmProcessDID(pArg);
}

void
ProcessingState::exit ( FsmBody& /* b */, FsmBehaviour& s, boost::any& pArg )
{
   s.vFsmStopProcessingTimer(pArg);
}

void
ProcessingState::evCheckCompletion ( FsmBody& b, FsmBehaviour& s,boost::any& pArg )
{
   if ( s.bIsProcessingComplete(pArg) )
   {
        //... performing exit actions ...
        exit(b,s,pArg);
        // transition Actions
        s.vFsmSendResponse(pArg);
        b.setState(b.oIdleState,pArg);
    }
    else
    {
   // transition Actions
   s.vFsmSetNextDID(pArg);
   s.vFsmProcessDID(pArg);
   // this is an internal transition
    }
}

void
ProcessingState::evIdle ( FsmBody& b, FsmBehaviour& s, boost::any& pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ProcessingState::evResponseReceived ( FsmBody& b, FsmBehaviour& s, boost::any& pArg )
{
   // transition Actions
   s.vFsmEvaluateResponse(pArg);
   // trigger events
   FsmEvent event = dia_MultipleReadFSM::evUnknown;

   event = dia_MultipleReadFSM::evCheckCompletion; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
}

void
ProcessingState::evTimeout ( FsmBody& b, FsmBehaviour& s, boost::any& pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrCode_Timeout(pArg);
   s.vFsmSendResponse(pArg);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, boost::any& pArg )
{
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, boost::any& pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    boost::any initVal = 0;
    oIdleState.initState(&oTopLevelState);
    oProcessingState.initState(&oTopLevelState);
    oTopLevelState.initSuperState(0, &oIdleState, false);

    setState(oTopLevelState,initVal);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, boost::any& param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, boost::any &param )
{
    if ( !mQueueSize || param.empty())
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, boost::any& pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        boost::any    nextArg   = 0;
        if ( !getEvent(nextEvent,nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evCheckCompletion:
            if ( mpState ) mpState->evCheckCompletion(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evStartProcessing:
            if ( mpState ) mpState->evStartProcessing(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, boost::any& pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


} // namespace
