///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineInternalTesterFSM.cpp
//
// Generated by SMC 4.4.0 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#include <string.h>

#ifndef __INCLUDED_DIA_ENGINEINTERNALTESTERFSM__
#include "dia_EngineInternalTesterFSM.h"
#endif

namespace dia_EngineInternalTesterFSM
{

const unsigned int MAX_TRIGGER_EVENTS = 20;

const unsigned int MAX_DEFERRED_EVENTS = 25;

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class Fsm;
class FsmSuperState;

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states.
//
///////////////////////////////////////////////////////////////////////////////

class FsmState
{
public:
   //! name of the FSM's state
   virtual const char* getStateName ( void ) const = 0;

   //! resetting state internals
   virtual void reset ( void ) {}

   // event functions 
   virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! default implementation for the Entry action
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! default implementation for the Exit action
   virtual void exit  ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! return the parent state
   virtual FsmSuperState* getParent ( void );

   //! assign the body object
   void initState ( FsmSuperState* pParent );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmState ( void );
   //! class destructor
   virtual ~FsmState ( void );

   //! pointer to the superstate
   FsmSuperState* mpParent;
};

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

class FsmSuperState
   : public FsmState
{
public:
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );
   //! default action
   virtual void defaultAction ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! resetting state internals
   virtual void reset ( void ) { _history = 0; }

   //! method used to propagate the event to the superstate
   virtual const FsmState* propagate ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! assign the body object
   void initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable=false );

protected:
   //! default constructor is protected to prevent usage of this constructor
   FsmSuperState ( void );

   //! pointer to the default substate
   FsmState* _default;
   //! pointer to the history substate
   const FsmState* _history;
   //! flag that indicates if history is enabled or not
   bool _historyEnable;
};

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ChangeSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ChangeSessionState
   : public FsmState
{
public:
   //! default constructor
   ChangeSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evDone ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ChangeSessionState::mStateName = "ChangeSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorHandlingState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ErrorHandlingState
   : public FsmState
{
public:
   //! default constructor
   ErrorHandlingState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* ErrorHandlingState::mStateName = "ErrorHandling";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class IdleState
   : public FsmState
{
public:
   //! default constructor
   IdleState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* IdleState::mStateName = "Idle";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessRequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class ProcessRequestState
   : public FsmSuperState
{
public:
   //! default constructor
   ProcessRequestState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! exit actions
   virtual void exit ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* ProcessRequestState::mStateName = "ProcessRequest";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RestoreSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class RestoreSessionState
   : public FsmState
{
public:
   //! default constructor
   RestoreSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* RestoreSessionState::mStateName = "RestoreSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendRequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SendRequestState
   : public FsmState
{
public:
   //! default constructor
   SendRequestState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! entry actions
   virtual void entry ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* SendRequestState::mStateName = "SendRequest";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SwitchSessionState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class SwitchSessionState
   : public FsmSuperState
{
public:
   //! default constructor
   SwitchSessionState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* SwitchSessionState::mStateName = "SwitchSession";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class TopLevelState
   : public FsmSuperState
{
public:
   //! default constructor
   TopLevelState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* TopLevelState::mStateName = "TopLevel";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitForResponseState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class WaitForResponseState
   : public FsmState
{
public:
   //! default constructor
   WaitForResponseState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evResponseReceived ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg );

   //! deferred events
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );


protected:
   //! array for recording received events to be deferred
   FsmEvent _deferredEvents[MAX_DEFERRED_EVENTS];
   //! array for recording params of events to be deferred
   void*    _deferredParams[MAX_DEFERRED_EVENTS];
   //! number of events currently deferred
   int _numDeferredEvents;


protected:
   static const char* mStateName;
};

const char* WaitForResponseState::mStateName = "WaitForResponse";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: processState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class processState
   : public FsmState
{
public:
   //! default constructor
   processState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   virtual void evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg );

protected:
   static const char* mStateName;
};

const char* processState::mStateName = "process";

///////////////////////////////////////////////////////////////////////////////
// 
// Class: waitingForRequestState
// 
// Concrete state of FSM
// 
///////////////////////////////////////////////////////////////////////////////

class waitingForRequestState
   : public FsmSuperState
{
public:
   //! default constructor
   waitingForRequestState ( void );

   //! return state name
   virtual const char* getStateName ( void ) const { return mStateName; }

   //! event functions
   virtual void evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg );
   //! set a savepoint for the history
   virtual void savepoint ( FsmBody& b );

protected:
   static const char* mStateName;
};

const char* waitingForRequestState::mStateName = "waitingForRequest";

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBody
//
// This is the finite state machine's body class 'FsmBody'.
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody
{
    struct FsmDeferredEvent
    {
          FsmDeferredEvent() : mEvent(evUnknown), mArg(0) {}
          FsmEvent mEvent;
          void*    mArg;
    };

public:
    //! class constructor
    FsmBody ( void );

    //! connect the FSM body with its frontend
    void connect ( Fsm* frontend );

    //! initialize the FSM: set initial state and execute initial actions
    bool init ( void );

    //! this method is used to stimulate the FSM with events
    void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the active state
    const char* getStateName ( void ) const;

    //! push trigger events to the event queue
    bool addEvent ( const FsmEvent& event, void* arg  );
    //! get event from the event queue
    bool getEvent ( FsmEvent& event, void** arg  );
    //! get event from the event queue
    bool isQueueEmpty ( void ) const;

    //! push deferred events to the pool of deferred events
    bool addDeferredEvent ( const FsmEvent& event, void* arg );
    //! get deferred event from the pool of deferred events
    bool getDeferredEvent ( FsmEvent& event, void** arg );
    //! check if the event pool is empty
    bool isPoolOfDeferredEventsEmpty ( void ) const;

    // set the FSM's internal state and propagate to default or history substate
    void setState ( FsmState& state, void* pArg );
    // set the FSM's internal state (no propagation
    void setState ( FsmState* pState );
    // return the active state object
    const FsmState* getState ( void ) const;

    //! static state objects
    ChangeSessionState oChangeSessionState;
    ErrorHandlingState oErrorHandlingState;
    IdleState oIdleState;
    ProcessRequestState oProcessRequestState;
    RestoreSessionState oRestoreSessionState;
    SendRequestState oSendRequestState;
    SwitchSessionState oSwitchSessionState;
    TopLevelState oTopLevelState;
    WaitForResponseState oWaitForResponseState;
    processState oprocessState;
    waitingForRequestState owaitingForRequestState;

    //! frontend for this body
    Fsm* mpFrontend;
    //! link to the active state object
    FsmState* mpState;

    //! busy indicator flag
    bool mBusyFlag;

    //! queue of trigger events
    FsmEvent mEventQueue[MAX_TRIGGER_EVENTS];
    //! queue of arguments for trigger events
    void*    mParamQueue[MAX_TRIGGER_EVENTS];
    //! index of the queue's front element
    unsigned int mQueueHead;
    //! index of the queue's back element
    unsigned int mQueueTail;
    //! number of queued events
    unsigned int mQueueSize;
    //! pool of deferred events
    FsmDeferredEvent mDeferredEventPool[MAX_DEFERRED_EVENTS];
    //! index of the pool's front element
    unsigned int mPoolHead;
    //! index of the pool's back element
    unsigned int mPoolTail;
    //! number of deferred events stored in the pool
    unsigned int mPoolSize;
};

///////////////////////////////////////////////////////////////////////////////
//
// Default implementation for all events.
//
///////////////////////////////////////////////////////////////////////////////

void
FsmState::evDone ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evDone *** 
}

void
FsmState::evErrorHandled ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evErrorHandled *** 
}

void
FsmState::evFinalise ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evFinalise *** 
}

void
FsmState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evIdle *** 
}

void
FsmState::evProcessed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessed *** 
}

void
FsmState::evProcessingFailed ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessingFailed *** 
}

void
FsmState::evProcessRequest ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evProcessRequest *** 
}

void
FsmState::evRequestSent ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evRequestSent *** 
}

void
FsmState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evResponseReceived *** 
}

void
FsmState::evTimeout ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
    // *** Ignoring Event evTimeout *** 
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM states components.
//
///////////////////////////////////////////////////////////////////////////////

FsmState::FsmState ( void )
   : mpParent(0)
{}

FsmState::~FsmState ( void )
{
   // make lint happy
   mpParent = 0;
}

void
FsmState::initState ( FsmSuperState* pParent )
{
   mpParent = pParent;
}

void
FsmState::entry ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

void
FsmState::exit ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   //... empty as default ...
}

const FsmState*
FsmState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.setState(this);
   entry(b,s,pArg);
   return this;
}

FsmSuperState*
FsmState::getParent ( void )
{
   return (mpParent) ? mpParent : 0;
}

///////////////////////////////////////////////////////////////////////////////
//
// Abstract base class for all FSM superstates.
//
///////////////////////////////////////////////////////////////////////////////

FsmSuperState::FsmSuperState ( void )
   : _default(0),
     _history(0),
     _historyEnable(false)
{}

void
FsmSuperState::initSuperState ( FsmSuperState* pParent, FsmState* defState, bool histEnable )
{
   mpParent = pParent;
   _default = defState;
   _history = 0;
   _historyEnable = histEnable;
}

const FsmState*
FsmSuperState::propagate ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   const FsmState* pState = 0;

   // we have crossed a state boundary
   b.setState(this);
   // execute the entry actions for this superstate
   entry(b,s,pArg);
   
   if ( _history && _historyEnable )
   {
      pState = const_cast<FsmState*>(_history)->propagate(b,s,pArg);
   }
   else
   {
      defaultAction(b,s,pArg);
      if ( _default ) {
         pState = _default->propagate(b,s,pArg);
      }
   }
   
   return pState;
}

void
FsmSuperState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
   }
}

void
FsmSuperState::defaultAction ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /*pArg*/ )
{
   //... empty as default ...
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ChangeSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ChangeSessionState::ChangeSessionState ( void )
{}

void
ChangeSessionState::evDone ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evFinalise; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oIdleState,pArg);
}

void
ChangeSessionState::evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRestoreRequest(pArg);
   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oprocessState,pArg);
}

void
ChangeSessionState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   b.setState(b.oIdleState,pArg);
}

void
ChangeSessionState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsResponsePending(pArg) )
   {
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.owaitingForRequestState.savepoint(b);

   b.setState(b.oProcessRequestState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ErrorHandlingState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ErrorHandlingState::ErrorHandlingState ( void )
{}

void
ErrorHandlingState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmLogError(pArg);
   s.vFsmHandleError(pArg);
}

void
ErrorHandlingState::evErrorHandled ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendError(pArg);
   b.setState(b.oIdleState,pArg);
}

void
ErrorHandlingState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

void
ErrorHandlingState::evProcessRequest ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmRejectRequest(pArg);
   // this is an internal transition
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: IdleState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

IdleState::IdleState ( void )
{}

void
IdleState::evFinalise ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmSendResponse(pArg);
   // this is an internal transition
}

void
IdleState::evIdle ( FsmBody& /* b */, FsmBehaviour& /* s */, void* /* pArg */ )
{
   // this is an internal transition
}

void
IdleState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsResponsePending(pArg) )
   {
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    } 
    else if ( s.bFsmIsAccepted(pArg) && s.bFsmIsValidRequest(pArg) && s.bFsmNoSessionChangeRequired(pArg) )
   {
        // set savepoint in superstate with enabled history
        b.owaitingForRequestState.savepoint(b);

        // transition Actions
        s.vFsmReset(pArg);
        s.vFsmStoreRequest(pArg);
        b.setState(b.oProcessRequestState,pArg);
    } 
    else if ( s.bFsmIsAccepted(pArg) && s.bFsmIsValidRequest(pArg) && s.bFsmNeedSessionChange(pArg) )
   {
        // transition Actions
        s.vFsmReset(pArg);
        s.vFsmStoreSession(pArg);
        s.vFsmStoreRequest(pArg);
        s.vFsmCreateSessionRequest(pArg);
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        b.setState(b.oSwitchSessionState,pArg);
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.owaitingForRequestState.savepoint(b);

   // transition Actions
   s.vFsmSetErrorInvalidRequest(pArg);
   b.setState(b.oErrorHandlingState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: ProcessRequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

ProcessRequestState::ProcessRequestState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
ProcessRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmStartTimer(pArg);
   s.vFsmInitializeProcessing(pArg);
}

void
ProcessRequestState::exit ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   s.vFsmStopTimer(pArg);
   s.vFsmFinalizeProcessing(pArg);
}

void
ProcessRequestState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
ProcessRequestState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorProcessingFailed(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessRequestState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResult(pArg);
   // this is an internal transition
}

void
ProcessRequestState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   //... performing exit actions ...
   exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorTimeout(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
ProcessRequestState::evProcessRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineInternalTesterFSM::evProcessRequest;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: RestoreSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

RestoreSessionState::RestoreSessionState ( void )
{}

void
RestoreSessionState::evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmClearResponsePending(pArg);
   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evDone; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oChangeSessionState,pArg);
}

void
RestoreSessionState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   b.setState(b.oIdleState,pArg);
}

void
RestoreSessionState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsResponsePending(pArg) )
   {
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.owaitingForRequestState.savepoint(b);

   b.setState(b.oProcessRequestState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SendRequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SendRequestState::SendRequestState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
SendRequestState::entry ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   _numDeferredEvents = 0;

   s.vFsmSendRequest(pArg);
}

void
SendRequestState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
SendRequestState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorProcessingFailed(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
SendRequestState::evRequestSent ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmWasSentSuccessfully(pArg) )
   {
        // trigger deferred events
        while ( !b.isPoolOfDeferredEventsEmpty() )
        {
            FsmEvent defevent = evUnknown;
            void*    defarg   = 0;
            if ( b.getDeferredEvent(defevent,&defarg) )
            {
                b.addEvent(defevent,defarg);
            }
        }
        b.setState(b.oWaitForResponseState,pArg);
    }
    else
    {
   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evProcessingFailed; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   // this is an internal transition
    }
}

void
SendRequestState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorTimeout(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
SendRequestState::evResponseReceived( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineInternalTesterFSM::evResponseReceived;

   b.addDeferredEvent(event,pArg);
}

void
SendRequestState::evProcessRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineInternalTesterFSM::evProcessRequest;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: SwitchSessionState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

SwitchSessionState::SwitchSessionState ( void )
{}

void
SwitchSessionState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oChangeSessionState.getStateName()) && (_history->getStateName() != b.oprocessState.getStateName()) && (_history->getStateName() != b.oRestoreSessionState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
SwitchSessionState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   b.setState(b.oIdleState,pArg);
}

void
SwitchSessionState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsResponsePending(pArg) )
   {
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   savepoint(b);
   // set savepoint in superstate with enabled history
   b.owaitingForRequestState.savepoint(b);

   b.setState(b.oProcessRequestState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: TopLevelState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

TopLevelState::TopLevelState ( void )
{}

void
TopLevelState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: WaitForResponseState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

WaitForResponseState::WaitForResponseState ( void )
   : _numDeferredEvents(0)
{
   (void) ::memset(_deferredEvents, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
   (void) ::memset(_deferredParams, 0, sizeof(FsmEvent)*MAX_DEFERRED_EVENTS);
}

void
WaitForResponseState::evIdle ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oIdleState,pArg);
}

void
WaitForResponseState::evProcessed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // transition Actions
   s.vFsmLogResult(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evFinalise; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.owaitingForRequestState,pArg);
}

void
WaitForResponseState::evProcessingFailed ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorProcessingFailed(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
WaitForResponseState::evResponseReceived ( FsmBody& /* b */, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmEvaluateResult(pArg);
   // this is an internal transition
}

void
WaitForResponseState::evTimeout ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   b.oProcessRequestState.exit(b,s,pArg);
   // transition Actions
   s.vFsmSetErrorTimeout(pArg);
   // trigger deferred events
   while ( !b.isPoolOfDeferredEventsEmpty() )
   {
       FsmEvent defevent = evUnknown;
       void*    defarg   = 0;
       if ( b.getDeferredEvent(defevent,&defarg) )
       {
           b.addEvent(defevent,defarg);
       }
   }
   b.setState(b.oErrorHandlingState,pArg);
}

void
WaitForResponseState::evProcessRequest( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // defer event
   FsmEvent event = dia_EngineInternalTesterFSM::evProcessRequest;

   b.addDeferredEvent(event,pArg);
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: processState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

processState::processState ( void )
{}

void
processState::evFinalise ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   // transition Actions
   s.vFsmCreateResponse(pArg);
   s.vFsmRestoreSession(pArg);
   // trigger events
   FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

   event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
   (void) b.addEvent(event,pArg);
   b.setState(b.oRestoreSessionState,pArg);
}

void
processState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   b.setState(b.oIdleState,pArg);
}

void
processState::evProcessRequest ( FsmBody& b, FsmBehaviour& s, void* pArg )
{
   if ( s.bFsmIsResponsePending(pArg) )
   {
        // trigger events
        FsmEvent event = dia_EngineInternalTesterFSM::evUnknown;

        event = dia_EngineInternalTesterFSM::evProcessRequest; //lint !e838 Info: Previously assigned value to variable has not been used
        (void) b.addEvent(event,pArg);
        // this is an internal transition
    }
    else
    {
   // set savepoint in superstate with enabled history
   b.oSwitchSessionState.savepoint(b);

   // set savepoint in superstate with enabled history
   b.owaitingForRequestState.savepoint(b);

   b.setState(b.oProcessRequestState,pArg);
    }
}

///////////////////////////////////////////////////////////////////////////////
// 
// Class: waitingForRequestState
// 
// Implementation of concrete FSM state
// 
///////////////////////////////////////////////////////////////////////////////

waitingForRequestState::waitingForRequestState ( void )
{}

void
waitingForRequestState::savepoint ( FsmBody& b )
{
   if ( _historyEnable )
   {
      _history = b.getState();
      while (  _history && (_history->getStateName() != b.oIdleState.getStateName()) && (_history->getStateName() != b.oSwitchSessionState.getStateName()) )
      {
         _history = const_cast<FsmState*>(_history)->getParent();
      }
   }
}

void
waitingForRequestState::evIdle ( FsmBody& b, FsmBehaviour& /* s */, void* pArg )
{
   savepoint(b);
   b.setState(b.oIdleState,pArg);
}

///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

Fsm::Fsm ( void )
    : mpBehaviour(0),
      mpBody(0)
{
}

Fsm::Fsm ( FsmBehaviour* server )
    : mpBehaviour(server),
      mpBody(0)
{}

Fsm::~Fsm ( void )
{
    if ( mpBody )
    {
        delete mpBody;
        mpBody = 0;
    }
    mpBehaviour = 0;
}

bool
Fsm::createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour )
{
   bool retCode = false;

   if ( ppFSM && behaviour )
   {
      (*ppFSM) = new Fsm(behaviour);
      if ( (*ppFSM) )
      {
         if ( !((*ppFSM)->init()) )
         {
            delete (*ppFSM);
            (*ppFSM) = 0;
         }
         else
         {
            retCode = true;
         }
      }
   }

   return retCode;
}

bool
Fsm::init ( void )
{
   bool retCode = false;
   
   mpBody = new FsmBody();
   
   if ( mpBody )
   {
      // connect the body with its frontend
      mpBody->connect(this);
      if ( mpBody->init() )
      {
          retCode = true;
      }
   }
   
   return retCode;
}

const char*
Fsm::getStateName (void) const
{
    return ( mpBody ) ? mpBody->getStateName() : 0;
}

void 
Fsm::acceptEvent ( FsmEvent event, void* pArg )
{
    if ( mpBody )
    {
        // forward the event to the FSM body (handle-body pattern)
        mpBody->acceptEvent(event,pArg);
    }
}
///////////////////////////////////////////////////////////////////////////////
//
// This is the finite state machine class implementation
//
///////////////////////////////////////////////////////////////////////////////

FsmBody::FsmBody ( void ) :
      mpFrontend(0),
      mpState(0),
      mBusyFlag(false),
      mQueueHead(0),
      mQueueTail(0),
      mQueueSize(0),
      mPoolHead(0),
      mPoolTail(0),
      mPoolSize(0)
{
    (void) ::memset(mEventQueue,0,sizeof(FsmEvent)*MAX_TRIGGER_EVENTS);
    (void) ::memset(mParamQueue,0,sizeof(void*)*MAX_TRIGGER_EVENTS);
}

bool
FsmBody::init ( void )
{
    oChangeSessionState.initState(&oSwitchSessionState);
    oErrorHandlingState.initState(&oTopLevelState);
    oIdleState.initState(&owaitingForRequestState);
    oProcessRequestState.initSuperState(&oTopLevelState, &oSendRequestState, false);
    oRestoreSessionState.initState(&oSwitchSessionState);
    oSendRequestState.initState(&oProcessRequestState);
    oSwitchSessionState.initSuperState(&owaitingForRequestState, &oChangeSessionState, true);
    oTopLevelState.initSuperState(0, &oIdleState, false);
    oWaitForResponseState.initState(&oProcessRequestState);
    oprocessState.initState(&oSwitchSessionState);
    owaitingForRequestState.initSuperState(&oTopLevelState, &oIdleState, true);

    setState(oTopLevelState,0);
    
    return true;
}

void
FsmBody::connect ( Fsm* frontend )
{
    mpFrontend = frontend;
}

const char*
FsmBody::getStateName ( void ) const
{
    return ( mpState ) ? mpState->getStateName() : 0;
}

bool
FsmBody::addEvent ( const FsmEvent& event, void* param )
{
    if ( mQueueSize < MAX_TRIGGER_EVENTS )
    {
        mQueueSize++;
        mEventQueue[mQueueTail] = event;
        mParamQueue[mQueueTail] = param;
        mQueueTail++;
        if ( mQueueTail == MAX_TRIGGER_EVENTS )
        {
            mQueueTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getEvent ( FsmEvent& event, void** param )
{
    if ( !mQueueSize || !param )
    {
        return false;
    }
    mQueueSize--;
    event  = mEventQueue[mQueueHead];
    *param = mParamQueue[mQueueHead];
    mQueueHead++;
    if ( mQueueHead == MAX_TRIGGER_EVENTS )
    {
        mQueueHead = 0;
    }
    return true;
}

bool
FsmBody::isQueueEmpty ( void ) const
{
    return ( mQueueSize ) ? false : true;
}

bool
FsmBody::addDeferredEvent ( const FsmEvent& event, void* arg )
{
    if ( mPoolSize < MAX_DEFERRED_EVENTS )
    {
        mPoolSize++;
        mDeferredEventPool[mPoolTail].mEvent = event;
        mDeferredEventPool[mPoolTail].mArg   = arg;
        mPoolTail++;
        if ( mPoolTail == MAX_DEFERRED_EVENTS )
        {
            mPoolTail = 0;
        }
        return true;
    }
    return false;
}

bool
FsmBody::getDeferredEvent ( FsmEvent& event, void** pArg )
{
    if ( !mPoolSize || !pArg )
    {
        return false;
    }
    mPoolSize--;
    event = mDeferredEventPool[mPoolHead].mEvent;
    *pArg = mDeferredEventPool[mPoolHead].mArg;
    mPoolHead++;
    if ( mPoolHead == MAX_DEFERRED_EVENTS )
    {
        mPoolHead = 0;
    }
    return true;
}

bool
FsmBody::isPoolOfDeferredEventsEmpty ( void ) const
{
    return ( mPoolSize ) ? false : true;
}

void 
FsmBody::acceptEvent ( FsmEvent event, void* pArg )
{
    (void) addEvent(event,pArg);

    if ( mBusyFlag )
    {
        return;
    }

    mBusyFlag = true;
    while ( !isQueueEmpty() )
    {
        FsmEvent nextEvent = evUnknown;
        void*    nextArg   = 0;
        if ( !getEvent(nextEvent,&nextArg) )
        {
            break;
        }

        switch (nextEvent)
        {
        case evDone:
            if ( mpState ) mpState->evDone(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evErrorHandled:
            if ( mpState ) mpState->evErrorHandled(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evFinalise:
            if ( mpState ) mpState->evFinalise(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evIdle:
            if ( mpState ) mpState->evIdle(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessed:
            if ( mpState ) mpState->evProcessed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessingFailed:
            if ( mpState ) mpState->evProcessingFailed(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evProcessRequest:
            if ( mpState ) mpState->evProcessRequest(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evRequestSent:
            if ( mpState ) mpState->evRequestSent(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evResponseReceived:
            if ( mpState ) mpState->evResponseReceived(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        case evTimeout:
            if ( mpState ) mpState->evTimeout(*this,*(mpFrontend->mpBehaviour),nextArg);
            break;

        default:
            //... unknown event ...
            break;
        } //lint !e788: not all items used within defaulted switch
    }
    mBusyFlag = false;
}

void 
FsmBody::setState ( FsmState& state, void* pArg )
{
    if ( mpFrontend )
    {
        mpState = const_cast<FsmState*>(state.propagate(*this,*(mpFrontend->mpBehaviour),pArg));
    }
}

void 
FsmBody::setState ( FsmState* pState )
{
    mpState = pState;
}

const FsmState*
FsmBody::getState ( void ) const
{
    return mpState;
}


} // namespace
