///////////////////////////////////////////////////////////////////////////////
//
// File: dia_EngineFlashFSM.h
//
// Generated by SMC 4.4.2 (C++ State Pattern Code Generator)
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __INCLUDED_DIA_ENGINEFLASHFSM__
#define __INCLUDED_DIA_ENGINEFLASHFSM__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

namespace dia_EngineFlashFSM
{

///////////////////////////////////////////////////////////////////////////////
//
// Forward Declarations
//
///////////////////////////////////////////////////////////////////////////////

class FsmBody;

///////////////////////////////////////////////////////////////////////////////
//
// Enums and typedefs
//
///////////////////////////////////////////////////////////////////////////////

//! enumeration of FSM events. First and last item added by SMC
enum FsmEvent
{
   evUnknown = 0,
   evCatalogAvailable,
   evCatalogError,
   evDataDownload,
   evDataError,
   evDataTransfer,
   evDataTransferFailed,
   evDataTransferred,
   evDone,
   evError,
   evErrorHandled,
   evExpectedIdent,
   evFlashContainerError,
   evFlashContainerOk,
   evIdle,
   evProcessed,
   evProcessingFailed,
   evResponseReceived,
   evStart,
   evStartUnpacking,
   evTerminate,
   evTimeout,
   evUnknownJob,
   evUnpacked,
   evUnpackingFailed,
   evWriteDataByID,
   evCount
};

///////////////////////////////////////////////////////////////////////////////
//
// Functions
//
///////////////////////////////////////////////////////////////////////////////

const char* getEventName ( FsmEvent event );

///////////////////////////////////////////////////////////////////////////////
//
// Class: FsmBehaviour
//
// This is the base class for the FSM server (provides implementation for all
// actions and guards)
//
///////////////////////////////////////////////////////////////////////////////

class FsmBehaviour
{ 
   friend class ChangeDiagnosticSessionState;
   friend class CheckingExpectedIdentState;
   friend class DisableFlushingState;
   friend class EnableFlushingState;
   friend class ErrorHandlingState;
   friend class FinalState;
   friend class FlashingState;
   friend class GetDataBlockState;
   friend class GetJobState;
   friend class IdleState;
   friend class ProcessDownloadState;
   friend class ProcessWDBIState;
   friend class ReadingCatalogState;
   friend class ReadingFlashContainerState;
   friend class RequestDownloadState;
   friend class RestoreDiagnosticSessionState;
   friend class TopLevelState;
   friend class TransferDataState;
   friend class TransferExitState;
   friend class TransferringDataState;
   friend class UnpackingState;
   friend class FsmBody;

public:
   virtual ~FsmBehaviour ( void ) {}

protected:
   // FSM actions
   virtual void vFsmAssembleData ( void* pArg ) = 0;
   virtual void vFsmCalcCRC ( void* pArg ) = 0;
   virtual void vFsmCheckForPDXContainer ( void* pArg ) = 0;
   virtual void vFsmDiagnosisActive ( void* pArg ) = 0;
   virtual void vFsmDiagnosisInactive ( void* pArg ) = 0;
   virtual void vFsmEvaluateJob ( void* pArg ) = 0;
   virtual void vFsmEvaluateResponseDownloadRequest ( void* pArg ) = 0;
   virtual void vFsmEvaluateResponseTransferData ( void* pArg ) = 0;
   virtual void vFsmEvaluateResponseTransferExit ( void* pArg ) = 0;
   virtual void vFsmEvaluateResponseWDBI ( void* pArg ) = 0;
   virtual void vFsmEvalueteResponseExpectedIdent ( void* pArg ) = 0;
   virtual void vFsmFinalize ( void* pArg ) = 0;
   virtual void vFsmFinalizeFlashing ( void* pArg ) = 0;
   virtual void vFsmFinalizeFlashProcess ( void* pArg ) = 0;
   virtual void vFsmFlashingComplete ( void* pArg ) = 0;
   virtual void vFsmGetNextBlock ( void* pArg ) = 0;
   virtual void vFsmGetNextJob ( void* pArg ) = 0;
   virtual void vFsmHandleCatalogError ( void* pArg ) = 0;
   virtual void vFsmHandleDataError ( void* pArg ) = 0;
   virtual void vFsmHandleDataTransferError ( void* pArg ) = 0;
   virtual void vFsmHandleDisableFlushingError ( void* pArg ) = 0;
   virtual void vFsmHandleEnableFlushingError ( void* pArg ) = 0;
   virtual void vFsmHandleError ( void* pArg ) = 0;
   virtual void vFsmHandleExpectedIdentError ( void* pArg ) = 0;
   virtual void vFsmHandleFlashContainerError ( void* pArg ) = 0;
   virtual void vFsmHandleRequestDownloadError ( void* pArg ) = 0;
   virtual void vFsmHandlerTransferExitError ( void* pArg ) = 0;
   virtual void vFsmHandleSessionChangeError ( void* pArg ) = 0;
   virtual void vFsmHandleTimeout ( void* pArg ) = 0;
   virtual void vFsmHandleUnknownJob ( void* pArg ) = 0;
   virtual void vFsmHandleUnpackingError ( void* pArg ) = 0;
   virtual void vFsmHandleWDBIError ( void* pArg ) = 0;
   virtual void vFsmInitialize ( void* pArg ) = 0;
   virtual void vFsmInitializeFlashing ( void* pArg ) = 0;
   virtual void vFsmLoadJobs ( void* pArg ) = 0;
   virtual void vFsmLogError ( void* pArg ) = 0;
   virtual void vFsmReadData ( void* pArg ) = 0;
   virtual void vFsmReadODXFlashContainer ( void* pArg ) = 0;
   virtual void vFsmReadPDXCatalog ( void* pArg ) = 0;
   virtual void vFsmRemovePDXContainer ( void* pArg ) = 0;
   virtual void vFsmRestoreActiveSession ( void* pArg ) = 0;
   virtual void vFsmSendRequestDisableFlushing ( void* pArg ) = 0;
   virtual void vFsmSendRequestDownloadRequest ( void* pArg ) = 0;
   virtual void vFsmSendRequestEnableFlushing ( void* pArg ) = 0;
   virtual void vFsmSendRequestReadIdent ( void* pArg ) = 0;
   virtual void vFsmSendRequestSessionChange ( void* pArg ) = 0;
   virtual void vFsmSendRequestTransferData ( void* pArg ) = 0;
   virtual void vFsmSendRequestTransferExit ( void* pArg ) = 0;
   virtual void vFsmSendRequestWDBI ( void* pArg ) = 0;
   virtual void vFsmSplitData ( void* pArg ) = 0;
   virtual void vFsmStartTimerDownload ( void* pArg ) = 0;
   virtual void vFsmStartTimerExpectedIdent ( void* pArg ) = 0;
   virtual void vFsmStartTimerFlushing ( void* pArg ) = 0;
   virtual void vFsmStartTimerSession ( void* pArg ) = 0;
   virtual void vFsmStartTimerWDBI ( void* pArg ) = 0;
   virtual void vFsmStopTimer ( void* pArg ) = 0;
   virtual void vFsmStoreActiveSession ( void* pArg ) = 0;
   virtual void vFsmUnpackPDXContainer ( void* pArg ) = 0;

   // FSM guards
   virtual bool bFsmHasCatalogFlashContainer ( void* pArg ) = 0;
   virtual bool bFsmIsDataTransferComplete ( void* pArg ) = 0;
   virtual bool bFsmIsPDXContainerAvailable ( void* pArg ) = 0;
   virtual bool bFsmNeedToDisableFlushing ( void* pArg ) = 0;
   virtual bool bFsmWasTimerStarted ( void* pArg ) = 0;
};

///////////////////////////////////////////////////////////////////////////////
//
// Class: Fsm
//
// This is the finite state machine class 'dia_EngineFlashFSM'.
//
///////////////////////////////////////////////////////////////////////////////

class Fsm
{
    //! we grant the body class access to our protected section
    friend class FsmBody;

public:
    //! factory method used to create an FAM object in two stages
    static bool createFSM ( Fsm** ppFSM, FsmBehaviour* behaviour );
    //! class destructor
    virtual ~Fsm ( void );

    //! this method is used to stimulate the FSM with events
    virtual void acceptEvent ( FsmEvent event, void* pArg );

    //! return the name of the current state
    virtual const char* getStateName ( void ) const;

protected:
    //! protected default constructor to avoid usage
    Fsm ( void );
    //! class constructor
    Fsm ( FsmBehaviour* behaviour );
    //! copy constructor without implementation
    Fsm ( const Fsm& obj );
    //! assignment operator without implementation
    Fsm& operator = ( const Fsm& obj );

    //! setup and initialize the state machine
    virtual bool init ( void );

protected:
    //! pointer to the server that provides the implementation for the actions and guards
    FsmBehaviour* mpBehaviour;
    //! body of the FSM implementation
    FsmBody* mpBody;
};


} // namespace

#endif
