/*!
 * \file       dia_TemperatureHistogramPlugin.h
 *
 * \brief      Field Load Data plugin for temperature sensors
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_TEMPERATUREHISTOGRAM_PLUGIN__
#define __INCLUDED_DIA_TEMPERATUREHISTOGRAM_PLUGIN__


#ifndef __INCLUDED_DIA_INTERFACE_HEAT_CONTROL_LISTENER__
#include "common/interfaces/dia_IHeatControlListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TEMPERATURE_HISTOGRAM_LISTENER__
#include "common/interfaces/dia_ITemperatureHistogramListener.h"
#endif

#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_PLUGIN__
#include "dia_FieldLoadDataPlugin.h"
#endif

#ifndef __INCLUDED_DIA_TEMPERATURE_HISTOGRAM__
#include "dia_TemperatureHistogram.h"
#endif

#include <vector>

namespace dia{

class TemperatureHistogram;

class TemperatureHistogramPlugin:
         public FieldLoadDataPlugin,
         public dia_IHeatControlListenerImpl,
         public ITemperatureHistogram
{
public:
   TemperatureHistogramPlugin(uint32_t maxNumHistograms=mMaxNumHistogramsDefault);
   virtual ~TemperatureHistogramPlugin();
   //! Overloaded Method from FieldLoadDataPlugin
   virtual void ProcessPluginStart(void);
   //! Overloaded Method from FieldLoadDataPlugin
   virtual void ProcessPluginUpdate(void);
   //! Overloaded Method from FieldLoadDataPlugin
   virtual void ProcessPluginStop(void);
   //! Overloaded Method from HeatControlListener
   virtual void vOnTemperatureInfo(std::list<dia_tHeatCtrlTemperature>& tempList);

   //! Overloaded Method from ITemperatureHistogram
   virtual tDiaResult getTemperatureHistogram (dia_eHeatCtrlTemperatureID id );


public:
   static const uint32_t mMaxNumHistogramsDefault=10;

protected:
   TemperatureHistogram *getHistogram(dia_eHeatCtrlTemperatureID id);

   TemperatureHistogram &accessHistogram(dia_eHeatCtrlTemperatureID id);

   tDiaResult UpdateTemperatureHistograms(std::list<dia_tHeatCtrlTemperature>& sensordata);
   std::vector<TemperatureHistogram> mHistogramRepo;
   static std::string HistStorageDirectory;
   uint32_t mMaxNumHistograms;

};
}
#endif

