/*!
 * \file       dia_TemperatureHistogram.cpp
 *
 * \brief      responsible for constructing histogram data for  
 *             temperature sensors and maintain them in persistent storage 
 *
 * \details    see header
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_TEMPERATURE_HISTOGRAM__
#include "dia_TemperatureHistogram.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_DATAPOOL__
#include "common/framework/config/dia_PropertyBagDatapool.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_FILE__
#include <common/framework/config/dia_PropertyBagFile.h>
#endif

namespace dia {
TemperatureHistogram::TemperatureHistogram(dia_eHeatCtrlTemperatureID id):
   mId(id),
   mTemperatureMin(0),
   mTemperatureMax(0),
   mtimeResolution(1) //Update Value in minutes
{
   mData.fill(0);
}

TemperatureHistogram::~TemperatureHistogram()
{
}

void 
TemperatureHistogram::addMeasurement(tS16 temperature)
{
   temperature=temperature/TEMPERATURE_OFFSET;
   uint8_t index = getHistogramIndex(temperature);
   DIA_TR_INF("TemperatureHistogram::addMeasurement(%u) oldVal=%u", index, mData[index]);

   mData[index] += mtimeResolution;
}

void
TemperatureHistogram::addTemperatureMin(tS16 temperatureMin)
{
	mTemperatureMin=temperatureMin/TEMPERATURE_OFFSET;
	DIA_TR_INF("TemperatureHistogram::addTemperatureMin lowest temperature is %d",mTemperatureMin);
}

void
TemperatureHistogram::addTemperatureMax(tS16 temperatureMax)
{
	mTemperatureMax=temperatureMax/TEMPERATURE_OFFSET;
	DIA_TR_INF("TemperatureHistogram::addTemperatureMax highest temperature is %d",mTemperatureMax);
}
uint8_t 
TemperatureHistogram::getHistogramIndex(tS16 value)
{
   if(value < TEMPERATURE_OFFSET_LOWER) {
      return (uint8_t)0;
   }
   else if (value >= TEMPERATURE_OFFSET_HIGHER) {
      return (uint8_t)TEMPERATURE_HISTOGRAM_LENGTH -1;
   }
   else 
   {
      tS16 normalizedvalue = (tS16)(value - TEMPERATURE_OFFSET_LOWER);
      return (uint8_t)((normalizedvalue/TEMPERATURE_HISTOGRAM_DEGREE_RANGE_RESOLUTION) + 1);
   }
}


}
