/*!
 * \file       dia_FieldLoadDataManager.cpp
 *
 * \brief      manager of the field load data plugins
 *
 * \details    -
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFrw
 *
 * \copyright  (c) 2019 Robert Bosch Car Multimedia
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */
#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_TRACE__
#include "common/framework/trace/dia_trace.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_FIELD_LOAD_DATA_MANAGER__
#include "dia_FieldLoadDataManager.h"
#endif

namespace dia{
FieldLoadDataManager*
getInstanceOfFieldLoadDataManager ( void )
{
   return FieldLoadDataManager::getInstance();
}

void
releaseInstanceOfFieldLoadDataManager ( void )
{
   FieldLoadDataManager::deleteInstance();
}

DIA_IMPL_SINGLETON(FieldLoadDataManager)

FieldLoadDataManager::FieldLoadDataManager():
   mIsSetupDone(false),
   mSelfTimer(this, this->mRefCounter)
{
   dia::ScopeTrace oTrace("FieldLoadDataManager::FieldLoadDataManager");
   init();
}

FieldLoadDataManager::~FieldLoadDataManager()
{
}

void
FieldLoadDataManager::init()
{
   mIsSetupDone = true;
}

void
FieldLoadDataManager::start()
{
   dia::ScopeTrace oTrace("FieldLoadDataManager::start()");

   std::list<std::shared_ptr<FieldLoadDataPlugin>>::iterator iter;
   for ( iter=mPluginRep.begin(); iter != mPluginRep.end(); iter++ )
   {
      (*iter)->ProcessPluginStart();
   }
   mSelfTimer.start(FieldLoadDataManager::resolution,FieldLoadDataManager::resolution);
}

void
FieldLoadDataManager::stop()
{
   dia::ScopeTrace oTrace("FieldLoadDataManager::stop()");
   mIsSetupDone = false;
   std::list<std::shared_ptr<FieldLoadDataPlugin>>::iterator iter;
   for ( iter=mPluginRep.begin(); iter != mPluginRep.end(); iter++ )
   {
      (*iter)->ProcessPluginStop();
   }
}

void
FieldLoadDataManager::update()
{
   dia::ScopeTrace oTrace("FieldLoadDataManager::update()");
   std::list<std::shared_ptr<FieldLoadDataPlugin>>::iterator iter;
   for ( iter=mPluginRep.begin(); iter != mPluginRep.end(); iter++ )
   {
      (*iter)->ProcessPluginUpdate();
   }
}

tDiaResult
FieldLoadDataManager::addFieldLoadDataPlugin ( const std::shared_ptr<FieldLoadDataPlugin>& plugin )
{
   dia::ScopeTrace oTrace("FieldLoadDataManager::addFieldLoadDataPlugin()");

   tDiaResult retCode = DIA_FAILED;

   if ( plugin )
   {
      auto iter = std::find(mPluginRep.begin(), mPluginRep.end(), plugin);
      if ( iter == mPluginRep.end() )
      {
         mPluginRep.push_back(plugin);
         retCode = DIA_SUCCESS;
      }
   }

   if (DIA_FAILED==retCode)
   {
      DIA_TR_ERR("ERROR  FieldLoadDataManager::addFieldLoadDataPlugin failed to add plugin (plugin=0x%p)", plugin.get());
   }

   return retCode;
}

void FieldLoadDataManager::onTimeout(MsgTimeout * /* msg */ ) {
   dia::ScopeTrace oTrace("FieldLoadDataManager::onTimeout()");
   update();
   mSelfTimer.start(FieldLoadDataManager::resolution,FieldLoadDataManager::resolution);
}


}

