/*
 * dia_FactoryPluginRunIn.h
 *
 *  Created on: 24.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_RUNIN__
#define __INCLUDED_DIA_FACTORY_PLUGIN_RUNIN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include <common/framework/factory/dia_FactoryPlugin.h>
#endif

//class dia_Application;
//class dia_CommandControllerPlugin;
//class dia_EngineManager;
class dia_CommandInfoUDS;
class dia_EngineRunIn;
class dia_EngineRunInConfiguration;

class dia_FactoryPluginRunIn
   : public dia_FactoryPlugin
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_FactoryPluginRunIn);

public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level ) { return tearDownObjects(level); }

   virtual dia_EngineRunIn* getEngine ( void ) { return mpEngine; }

protected:
   //! class constructor
   dia_FactoryPluginRunIn ( void );
   //! class destructor
   virtual ~dia_FactoryPluginRunIn ( void );

   //! tear down all objects created by this class
   tDiaResult tearDownObjects ( dia_enInitLevel level=DIA_EN_INITLEVEL_ALL);

protected:
   dia_EngineRunIn* mpEngine;
   dia_EngineRunInConfiguration* mpConfig;
//   //! pointer to the diagnosis application
//   dia_Application*   mpApp;
//   //! pointer to the ConfigManager
//   dia_ConfigManager* mpConfigMgr;
//   //! pointer to the application controller
//   dia_AppController* mpAppCtrl;
//   //! pointer to the engine manager
//   dia_EngineManager* mpEngMgr;
//   //! command controller plugins
//   std::list<dia_CommandControllerPlugin*> mCmdCtrlPluginRep;
   //! command controller plugins
   std::list<dia_CommandInfoUDS*> mCommandRep;
};

dia_FactoryPluginRunIn* getInstanceOfFactoryPluginRunIn ( void );
void releaseInstanceOfFactoryPluginRunIn ( void );

#endif /* DIA_FACTORYPLUGINRUNIN_H_ */
