/*
 * dia_FactoryPluginRunIn.cpp
 *
 *  Created on: 24.11.2014
 *      Author: gib2hi
 */

#include "dia_FactoryPluginRunIn.h"

#ifndef __INCLUDED_DIA_COMMON_FACTORY__
#include "common/framework/factory/dia_common_factory.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY_METHODS__
#include "common/framework/factory/dia_factoryMethods.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN__
#include <common/framework/engine/dia_EngineRunIn.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__
#include <common/framework/engine/dia_EngineRunInConfiguration.h>
#endif

#ifndef __INCLUDED_DIA_LOCK_SCOPE__
#include "common/framework/application/dia_LockScope.h"
#endif

// implementation of the singleton methods
DIA_IMPL_SINGLETON(dia_FactoryPluginRunIn)

#ifndef __DIA_UNIT_TESTING__

dia_FactoryPluginRunIn*
getInstanceOfFactoryPluginRunIn ( void )
{
   return dia_FactoryPluginRunIn::getInstance();
}

void
releaseInstanceOfFactoryPluginRunIn ( void )
{
   dia_FactoryPluginRunIn::deleteInstance();
}

#endif

//-----------------------------------------------------------------------------

dia_FactoryPluginRunIn::dia_FactoryPluginRunIn ( void )
   : dia_FactoryPlugin("dia_FactoryPluginRunIn",DIA_EN_FACTORY_PLUGIN_TYPE_RUNIN),
     mpEngine(0),
     mpConfig(0)
{}

//-----------------------------------------------------------------------------

dia_FactoryPluginRunIn::~dia_FactoryPluginRunIn ( void )
{
   _BP_TRY_BEGIN
   {
      (void) tearDownObjects();
      mpEngine = 0;
      mpConfig = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_FactoryPluginRunIn::~dia_FactoryPluginRunIn !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginRunIn::setup ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace(DIA_TRC_SM,"dia_FactoryPluginRunIn::setup");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level <= getInitializationLevel() )
   {
      DIA_TR_INF("##### REQUESTED LEVEL OF RUN-IN FACTORY ALREADY INITIALIZED. REQUEST IGNORED #####");
      return DIA_SUCCESS;
   }

   if ( level == DIA_EN_INITLEVEL_3 || level == DIA_EN_INITLEVEL_ALL )
   {
      DIA_TR_ERR("dia_FactoryPluginRunIn::setup => start RUNIN now");
      static tCString strRunInConfigName = "dia_EngineRunInConfiguration";

      //--- PRODUCTION SESSION --------------------------------------------------------------------

      static tCString strCmdName_ProdSession = "RunInCmd_ProductionSession";
      static const tU8 reqData_ProductionSession[3] = { 0x02, 0x10, 0x60 };

      // create the list of commands to be executed during a run-in session
      dia_CommandInfoUDS* pCmdProdSession = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_ProdSession,
            DIA_C_U8_UDS_SID_SESSION_CONTROL,
            0x60, 1,
            reqData_ProductionSession,
            sizeof(reqData_ProductionSession),
            0, // result will not be logged
            DIA_EN_UDS_CMD_TYPE_SESSION_CTRL
      );
      mCommandRep.push_back(pCmdProdSession);

      //--- SYSTEM OPERATION TIME -----------------------------------------------------------------

      static tCString strCmdName_SysOperationTime = "RunInCmd_SystemOperationTime";
      static tCString strLogFile_SysOperationTime = "system_operation_time";
      static const tU8 reqData_SysOperationTime[4] = { 0x03, 0x22, 0xB1, 0x01 };

      dia_CommandInfoUDS* pCmdSysOperationTime = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_SysOperationTime,
            DIA_C_U8_UDS_SID_READ_DATA_BY_IDENTIFIER,
            DIA_C_U16_DID_RBCM_SYSTEM_OPERATION_TIME, 2,
            reqData_SysOperationTime,
            sizeof(reqData_SysOperationTime),
            strLogFile_SysOperationTime,
            DIA_EN_UDS_CMD_TYPE_READ_DATA_BY_ID
      );
      mCommandRep.push_back(pCmdSysOperationTime);

      //--- ACC SELF TEST  ------------------------------------------------------------------------

      static tCString strCmdName_AccSelfTest = "RunInCmd_AccSelfTest";
      static tCString strLogFile_AccSelfTest = "selftest_acc";
      static const tU8 reqData_AccSelfTest[5] = { 0x04, 0x31, 0x01, 0x30, 0x42 };

      dia_CommandInfoUDS* pCmdAccSelfTest = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_AccSelfTest,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            0x3042, 2,
            reqData_AccSelfTest,
            sizeof(reqData_AccSelfTest),
            strLogFile_AccSelfTest,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1
      );
      mCommandRep.push_back(pCmdAccSelfTest);

      //--- GYRO SELF TEST  -----------------------------------------------------------------------

      static tCString strCmdName_GyroSelfTest = "RunInCmd_GyroSelfTest";
      static tCString strLogFile_GyroSelfTest = "selftest_gyro";
      static const tU8 reqData_GyroSelfTest[5] = { 0x04, 0x31, 0x01, 0x30, 0x43 };

      dia_CommandInfoUDS* pCmdGyroSelfTest = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_GyroSelfTest,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            0x3043, 2,
            reqData_GyroSelfTest,
            sizeof(reqData_GyroSelfTest),
            strLogFile_GyroSelfTest,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1
      );
      mCommandRep.push_back(pCmdGyroSelfTest);

      //--- IPOD SELF TEST  -----------------------------------------------------------------------

      static tCString strCmdName_IpodSelfTest = "RunInCmd_IpodSelfTest";
      static tCString strLogFile_IpodSelfTest = "selftest_ipod";
      static const tU8 reqData_IpodSelfTest[5] = { 0x04, 0x31, 0x01, 0x30, 0x40 };

      dia_CommandInfoUDS* pCmdIpodSelfTest = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_IpodSelfTest,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_IPOD_SELFTEST, 2,
            reqData_IpodSelfTest,
            sizeof(reqData_IpodSelfTest),
            strLogFile_IpodSelfTest,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1
      );
      mCommandRep.push_back(pCmdIpodSelfTest);

      //--- checksum RAW_NOR ----------------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumRawNor        = "RunInCmd_RtCtrlChecksumRawNor";
      static tCString strCmdName_RtCtrlChecksumRawNorResult  = "RunInCmd_RtCtrlChecksumRawNorResult";
      static tCString strLogFile_RtCtrlChecksumRawNor        = "chksum_nor_raw";
      static const tU8 reqData_RtCtrlChecksumRawNor[5]       = { 0x04, 0x31, 0x01, 0x30, 0x60 };
      static const tU8 reqData_RtCtrlChecksumRawNorResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x60 };

      dia_CommandInfoUDS* pCmdChecksumRawNor = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumRawNor,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW, 2,
            reqData_RtCtrlChecksumRawNor,
            sizeof(reqData_RtCtrlChecksumRawNor),
            strLogFile_RtCtrlChecksumRawNor,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );
      dia_CommandInfoUDS* pCmdChecksumRawNorResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumRawNorResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_NOR_RAW, 2,
            reqData_RtCtrlChecksumRawNorResult,
            sizeof(reqData_RtCtrlChecksumRawNorResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumRawNor && pCmdChecksumRawNorResult )
      {
         pCmdChecksumRawNorResult->mIsSubCommand = true;
         pCmdChecksumRawNor->mpSubCommand = pCmdChecksumRawNorResult;
         mCommandRep.push_back(pCmdChecksumRawNor);
      }

      //--- checksum V850_APP ----------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumV850App        = "RunInCmd_RtCtrlChecksumV850App";
      static tCString strCmdName_RtCtrlChecksumV850AppResult  = "RunInCmd_RtCtrlChecksumV850AppResult";
      static tCString strLogFile_RtCtrlChecksumV850App        = "chksum_v850_app";
      static const tU8 reqData_RtCtrlChecksumV850App[5]       = { 0x04, 0x31, 0x01, 0x30, 0x66 };
      static const tU8 reqData_RtCtrlChecksumV850AppResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x66 };

      dia_CommandInfoUDS* pCmdChecksumV850App = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumV850App,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP, 2,
            reqData_RtCtrlChecksumV850App,
            sizeof(reqData_RtCtrlChecksumV850App),
            strLogFile_RtCtrlChecksumV850App,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdChecksumV850AppResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumV850AppResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_APP, 2,
            reqData_RtCtrlChecksumV850AppResult,
            sizeof(reqData_RtCtrlChecksumV850AppResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumV850App && pCmdChecksumV850AppResult )
      {
         pCmdChecksumV850AppResult->mIsSubCommand = true;
         pCmdChecksumV850App->mpSubCommand = pCmdChecksumV850AppResult;
         mCommandRep.push_back(pCmdChecksumV850App);
      }
      //--- checksum V850_BOOT ----------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumV850Boot        = "RunInCmd_RtCtrlChecksumV850Boot";
      static tCString strCmdName_RtCtrlChecksumV850BootResult  = "RunInCmd_RtCtrlChecksumV850BootResult";
      static tCString strLogFile_RtCtrlChecksumV850Boot        = "chksum_v850_boot";
      static const tU8 reqData_RtCtrlChecksumV850Boot[5]       = { 0x04, 0x31, 0x01, 0x30, 0x65 };
      static const tU8 reqData_RtCtrlChecksumV850BootResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x65 };

      dia_CommandInfoUDS* pCmdChecksumV850Boot = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumV850Boot,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT, 2,
            reqData_RtCtrlChecksumV850Boot,
            sizeof(reqData_RtCtrlChecksumV850Boot),
            strLogFile_RtCtrlChecksumV850Boot,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdChecksumV850BootResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumV850BootResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_V850_BOOT, 2,
            reqData_RtCtrlChecksumV850BootResult,
            sizeof(reqData_RtCtrlChecksumV850BootResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumV850Boot && pCmdChecksumV850BootResult )
      {
         pCmdChecksumV850BootResult->mIsSubCommand = true;
         pCmdChecksumV850Boot->mpSubCommand = pCmdChecksumV850BootResult;
         mCommandRep.push_back(pCmdChecksumV850Boot);
      }

      //--- checksum EMMC_FFS ---------------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumEmmcFFS        = "RunInCmd_RtCtrlChecksumEmmcFFS";
      static tCString strCmdName_RtCtrlChecksumEmmcFFSResult  = "RunInCmd_RtCtrlChecksumEmmcFFSResult";
      static tCString strLogFile_RtCtrlChecksumEmmcFFS        = "chksum_emmc_ffs";
      static const tU8 reqData_RtCtrlChecksumEmmcFFS[5]       = { 0x04, 0x31, 0x01, 0x30, 0x63 };
      static const tU8 reqData_RtCtrlChecksumEmmcFFSResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x63 };

      dia_CommandInfoUDS* pCmdChecksumEmmcFFS = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcFFS,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS, 2,
            reqData_RtCtrlChecksumEmmcFFS,
            sizeof(reqData_RtCtrlChecksumEmmcFFS),
            strLogFile_RtCtrlChecksumEmmcFFS,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdChecksumEmmcFFSResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcFFSResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FFS, 2,
            reqData_RtCtrlChecksumEmmcFFSResult,
            sizeof(reqData_RtCtrlChecksumEmmcFFSResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumEmmcFFS && pCmdChecksumEmmcFFSResult )
      {
         pCmdChecksumEmmcFFSResult->mIsSubCommand = true;
         pCmdChecksumEmmcFFS->mpSubCommand = pCmdChecksumEmmcFFSResult;
         mCommandRep.push_back(pCmdChecksumEmmcFFS);
      }

      //--- checksum EMMC_FASTBOOT ----------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumEmmcFastBoot        = "RunInCmd_RtCtrlChecksumEmmcFastBoot";
      static tCString strCmdName_RtCtrlChecksumEmmcFastBootResult  = "RunInCmd_RtCtrlChecksumEmmcFastBootResult";
      static tCString strLogFile_RtCtrlChecksumEmmcFastBoot        = "chksum_emmc_fastboot";
      static const tU8 reqData_RtCtrlChecksumEmmcFastBoot[5]       = { 0x04, 0x31, 0x01, 0x30, 0x64 };
      static const tU8 reqData_RtCtrlChecksumEmmcFastBootResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x64 };

      dia_CommandInfoUDS* pCmdChecksumEmmcFastBoot = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcFastBoot,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT, 2,
            reqData_RtCtrlChecksumEmmcFastBoot,
            sizeof(reqData_RtCtrlChecksumEmmcFastBoot),
            strLogFile_RtCtrlChecksumEmmcFastBoot,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdChecksumEmmcFastBootResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcFastBootResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_FASTBOOT, 2,
            reqData_RtCtrlChecksumEmmcFastBootResult,
            sizeof(reqData_RtCtrlChecksumEmmcFastBootResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumEmmcFastBoot && pCmdChecksumEmmcFastBootResult )
      {
         pCmdChecksumEmmcFastBootResult->mIsSubCommand = true;
         pCmdChecksumEmmcFastBoot->mpSubCommand = pCmdChecksumEmmcFastBootResult;
         mCommandRep.push_back(pCmdChecksumEmmcFastBoot);
      }

      //--- checksum EMMC_RAW ---------------------------------------------------------------------

      static tCString strCmdName_RtCtrlChecksumEmmcRaw        = "RunInCmd_RtCtrlChecksumEmmcRaw";
      static tCString strCmdName_RtCtrlChecksumEmmcRawResult  = "RunInCmd_RtCtrlChecksumEmmcRawResult";
      static tCString strLogFile_RtCtrlChecksumEmmcRaw        = "chksum_emmc_raw";
      static const tU8 reqData_RtCtrlChecksumEmmcRaw[5]       = { 0x04, 0x31, 0x01, 0x30, 0x62 };
      static const tU8 reqData_RtCtrlChecksumEmmcRawResult[5] = { 0x04, 0x31, 0x03, 0x30, 0x62 };

      dia_CommandInfoUDS* pCmdChecksumEmmcRaw = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcRaw,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW, 2,
            reqData_RtCtrlChecksumEmmcRaw,
            sizeof(reqData_RtCtrlChecksumEmmcRaw),
            strLogFile_RtCtrlChecksumEmmcRaw,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdChecksumEmmcRawResult = OSAL_NEW dia_CommandInfoUDS (
            strCmdName_RtCtrlChecksumEmmcRawResult,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_CAV_CHECKSUM_EMMC_RAW, 2,
            reqData_RtCtrlChecksumEmmcRawResult,
            sizeof(reqData_RtCtrlChecksumEmmcRawResult),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdChecksumEmmcRaw && pCmdChecksumEmmcRawResult )
      {
         pCmdChecksumEmmcRawResult->mIsSubCommand = true;
         pCmdChecksumEmmcRaw->mpSubCommand = pCmdChecksumEmmcRawResult;
         mCommandRep.push_back(pCmdChecksumEmmcRaw);
      }

      //--- MainStress 1 --------------------------------------------------------------------------

      static tCString strCmdNameRtCtrlMainStress1 = "RunInCmd_RtCtrlMainStress1";
      static tCString strLogFile_IMainStress1     = "stress1";
      // "--cpu 2 --io 2 --vm 1 --vm-bytes 128M --vm-stride 255 --vm-hang 5"
      static const tU8 reqData_RtCtrlMainStress1[70] = {
         0x45, 0x31, 0x01, 0x32, 0x02, 0x2d, 0x2d, 0x63, 0x70, 0x75,
         0x20, 0x32, 0x20, 0x2d, 0x2d, 0x69, 0x6f, 0x20, 0x32, 0x20,
         0x2d, 0x2d, 0x76, 0x6d, 0x20, 0x31, 0x20, 0x2d, 0x2d, 0x76,
         0x6d, 0x2d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x31, 0x32,
         0x38, 0x4d, 0x20, 0x2d, 0x2d, 0x76, 0x6d, 0x2d, 0x73, 0x74,
         0x72, 0x69, 0x64, 0x65, 0x20, 0x32, 0x35, 0x35, 0x20, 0x2d,
         0x2d, 0x76, 0x6d, 0x2d, 0x68, 0x61, 0x6e, 0x67, 0x20, 0x35};

      // "--cpu 2 --io 20 --vm 1 --vm-bytes 128M --vm-stride 255 --vm-hang 5"
      //static const tU8 reqData_RtCtrlMainStress1[]         = { 0x46, 0x31, 0x01, 0x32, 0x02, 0x2d, 0x2d, 0x63, 0x70, 0x75, 0x20, 0x32, 0x20, 0x2d, 0x2d, 0x69, 0x6f, 0x20, 0x32 , 0x30 , 0x20 , 0x2d , 0x2d, 0x76, 0x6d, 0x20, 0x31, 0x20, 0x2d, 0x2d, 0x76, 0x6d, 0x2d, 0x62, 0x79, 0x74, 0x65, 0x73, 0x20, 0x31, 0x32, 0x38, 0x4d, 0x20, 0x2d, 0x2d, 0x76, 0x6d, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x64, 0x65, 0x20, 0x32, 0x35, 0x35, 0x20, 0x2d, 0x2d, 0x76, 0x6d, 0x2d, 0x68, 0x61, 0x6e, 0x67, 0x20, 0x35};


      dia_CommandInfoUDS* pCmdMainStress1 = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlMainStress1,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1, 2,
            reqData_RtCtrlMainStress1,
            sizeof(reqData_RtCtrlMainStress1),
            strLogFile_IMainStress1,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      mCommandRep.push_back(pCmdMainStress1);

      //--- MainStress 2 --------------------------------------------------------------------------

      static tCString strCmdNameRtCtrlMainStress2          = "RunInCmd_RtCtrlMainStress2";
      static tCString strCmdNameRtCtrlMainStress2Result    = "RunInCmd_RtCtrlMainStress2Result";
      static tCString strLogFile_IMainStress2              = "stress2";
      // "--hdd 1 --hdd-bytes 200M --timeout 10"
      static const tU8 reqData_RtCtrlMainStress2[42]       = {
         0x29, 0x31, 0x01, 0x32, 0x03, 0x2d, 0x2d, 0x68, 0x64, 0x64,
         0x20, 0x31, 0x20, 0x2d, 0x2d, 0x68, 0x64, 0x64, 0x2d, 0x62,
         0x79, 0x74, 0x65, 0x73, 0x20, 0x32, 0x30, 0x30, 0x4d, 0x20,
         0x2d, 0x2d, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x20,
         0x31, 0x30};
      static const tU8 reqData_RtCtrlMainStress2Result[5]  = { 0x04, 0x31, 0x03, 0x32, 0x03 };

      dia_CommandInfoUDS* pCmdMainStress2 = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlMainStress2,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_MAINSTRESS_2, 2,
            reqData_RtCtrlMainStress2,
            sizeof(reqData_RtCtrlMainStress2),
            strLogFile_IMainStress2,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      dia_CommandInfoUDS* pCmdMainStress2Result = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlMainStress2Result,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_RBCM_RTCTRL_MAINSTRESS_2, 2,
            reqData_RtCtrlMainStress2Result,
            sizeof(reqData_RtCtrlMainStress2Result),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT
      );

      if ( pCmdMainStress2 && pCmdMainStress2Result )
      {
         pCmdMainStress2Result->mIsSubCommand = true;
         pCmdMainStress2->mpSubCommand = pCmdMainStress2Result;
         mCommandRep.push_back(pCmdMainStress2);
      }

      //--- Display Slideshow --------------------------------------------------------------------------

#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
      static tCString strCmdNameRtCtrlDisplaySlideshow  = "RunInCmd_RtCtrlDisplaySlideshow";
      static tCString strLogFile_IDisplaySlideshow      = "slideshow_start";
      static const tU8 reqData_RtCtrlDisplaySlideshow[] = {0x08, 0x31, 0x01, 0x32, 0x04, 0x00, 0x00, 0x00, 0x32};

      dia_CommandInfoUDS* pCmdDisplaySlideshow = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlDisplaySlideshow,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW, 2,
            reqData_RtCtrlDisplaySlideshow,
            sizeof(reqData_RtCtrlDisplaySlideshow),
            0,//strLogFile_IDisplaySlideshow,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );
      mCommandRep.push_back(pCmdDisplaySlideshow);
#endif
      //-------------------------------------------------------------------------------------------
      //--- Post Processing commands --------------------------------------------------------------

      //--- MainStress 1 Stop ---------------------------------------------------------------------

      static tCString strCmdNameRtCtrlStopMainStress1 = "RunInCmd_RtCtrlStopMainStress1";
      static const tU8 reqData_RtCtrlStopMainStress1[5] = { 0x04, 0x31, 0x02, 0x32, 0x02};

      dia_CommandInfoUDS* pCmdStopMainStress1 = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlStopMainStress1,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_DIAGNOSIS_STRESS_TEST_1, 2,
            reqData_RtCtrlStopMainStress1,
            sizeof(reqData_RtCtrlStopMainStress1),
            0, // nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );

      mCommandRep.push_back(pCmdStopMainStress1);

#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
      //--- Display Slideshow Stop -------------------------------------------------------------------
      static tCString strCmdNameRtCtrlStopDisplaySlideshow  = "RunInCmd_RtCtrlStopDisplaySlideshow";
      static const tU8 reqData_RtCtrlStopDisplaySlideshow[5] = {0x04, 0x31, 0x02, 0x32, 0x04};

      dia_CommandInfoUDS* pCmdStopDisplaySlideshow = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlStopDisplaySlideshow,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW, 2,
            reqData_RtCtrlStopDisplaySlideshow,
            sizeof(reqData_RtCtrlStopDisplaySlideshow),
            0,// nothing is logged here, as this is only the subcommand to poll for completion of the routine
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2
      );
      mCommandRep.push_back(pCmdStopDisplaySlideshow);

      //--- Display Slideshow Get  -------------------------------------------------------------------
      static tCString strCmdNameRtCtrlGetDisplaySlideshow  = "RunInCmd_RtCtrlGetDisplaySlideshow";
      static tCString strLogFile_IGetDisplaySlideshow      = "testscreen";
      static const tU8 reqData_RtCtrlGetDisplaySlideshow[5] = {0x04, 0x31, 0x03, 0x32, 0x04};

      dia_CommandInfoUDS* pCmdGetDisplaySlideshow = OSAL_NEW dia_CommandInfoUDS (
            strCmdNameRtCtrlGetDisplaySlideshow,
            DIA_C_U8_UDS_SID_ROUTINE_CONTROL,
            DIA_C_U16_DID_DIAGNOSIS_DISPLAY_SLIDESHOW, 2,
            reqData_RtCtrlGetDisplaySlideshow,
            sizeof(reqData_RtCtrlGetDisplaySlideshow),
            strLogFile_IGetDisplaySlideshow,
            DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1
      );
      mCommandRep.push_back(pCmdStopDisplaySlideshow);
#endif
      //-------------------------------------------------------------------------------------------------
      // create the configuration object
      mpConfig = OSAL_NEW dia_EngineRunInConfiguration(strRunInConfigName);
      if ( mpConfig )
      {
         // add the commands to the configuration object
         if (pCmdProdSession) mpConfig->addCommand(*pCmdProdSession);
         if (pCmdSysOperationTime) mpConfig->addCommand(*pCmdSysOperationTime);
         if (pCmdAccSelfTest) mpConfig->addCommand(*pCmdAccSelfTest);
         if (pCmdGyroSelfTest) mpConfig->addCommand(*pCmdGyroSelfTest);
         if (pCmdIpodSelfTest) mpConfig->addCommand(*pCmdIpodSelfTest);
         if (pCmdMainStress1) mpConfig->addCommand(*pCmdMainStress1);
         if (pCmdMainStress2) mpConfig->addCommand(*pCmdMainStress2);
         if (pCmdChecksumRawNor) mpConfig->addCommand(*pCmdChecksumRawNor);
         if (pCmdChecksumV850App) mpConfig->addCommand(*pCmdChecksumV850App);
         if (pCmdChecksumV850Boot) mpConfig->addCommand(*pCmdChecksumV850Boot);
         if (pCmdChecksumEmmcFFS) mpConfig->addCommand(*pCmdChecksumEmmcFFS);
         if (pCmdChecksumEmmcFastBoot) mpConfig->addCommand(*pCmdChecksumEmmcFastBoot);
         if (pCmdChecksumEmmcRaw) mpConfig->addCommand(*pCmdChecksumEmmcRaw);
#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
         if (pCmdDisplaySlideshow) mpConfig->addCommand(*pCmdDisplaySlideshow);
         if (pCmdStopDisplaySlideshow) mpConfig->addPostProcessingCommand(*pCmdStopDisplaySlideshow);
#endif
         if (pCmdStopMainStress1) mpConfig->addPostProcessingCommand(*pCmdStopMainStress1);
#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
         if (pCmdGetDisplaySlideshow) mpConfig->addPostProcessingCommand(*pCmdGetDisplaySlideshow);
#endif
         // create the engine instance and configure it
         mpEngine = OSAL_NEW dia_EngineRunIn(DIA_NAME_ENGINE_PRODUCTION_UDS_RUN_IN,*mpConfig);
         if ( mpEngine )
         {
            if ( mpEngine->setup() != DIA_SUCCESS )
            {
               DIA_TR_ERR("### SETUP OF RUNIN-ENGINE FAILED !!! ###");
            }
            else
            {
               std::vector<tArgsType> vecArgs;
               if ( mpEngine->startControl(vecArgs) != DIA_SUCCESS )
               {
                  DIA_TR_ERR("### START OF RUNIN-ENGINE FAILED !!! ###");
               }
            }
         }
      }

      pCmdProdSession                  = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdSysOperationTime'. --> lifetime is controlled by instance of this class
      pCmdSysOperationTime             = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdSysOperationTime'. --> lifetime is controlled by instance of this class
      pCmdAccSelfTest                  = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdAccSelfTest'. --> lifetime is controlled by instance of this class
      pCmdGyroSelfTest                 = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdGyroSelfTest'. --> lifetime is controlled by instance of this class
      pCmdIpodSelfTest                 = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdIpodSelfTest'. --> lifetime is controlled by instance of this class
      pCmdChecksumRawNor               = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumRawNor'. --> lifetime is controlled by instance of this class
      pCmdChecksumRawNorResult         = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumRawNor'. --> lifetime is controlled by instance of this class
      pCmdChecksumV850App              = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumV850App'. --> lifetime is controlled by instance of this class
      pCmdChecksumV850AppResult        = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumV850App'. --> lifetime is controlled by instance of this class
      pCmdChecksumV850Boot             = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumV850Boot'. --> lifetime is controlled by instance of this class
      pCmdChecksumV850BootResult       = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumV850Boot'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcFFS              = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcFFS'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcFFSResult        = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcFFS'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcFastBoot         = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcFastBoot'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcFastBootResult   = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcFastBoot'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcRaw              = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcRaw'. --> lifetime is controlled by instance of this class
      pCmdChecksumEmmcRawResult        = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdChecksumEmmcRaw'. --> lifetime is controlled by instance of this class
      pCmdMainStress1                  = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdMainStress1'. --> lifetime is controlled by instance of this class
      pCmdMainStress2                  = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdMainStress2'. --> lifetime is controlled by instance of this class
      pCmdMainStress2Result            = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdMainStress2'. --> lifetime is controlled by instance of this class
#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
      pCmdDisplaySlideshow             = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdDisplaySlideshow'. --> lifetime is controlled by instance of this class
      pCmdStopDisplaySlideshow         = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdStopDisplaySlideshow'. --> lifetime is controlled by instance of this class
#endif
      pCmdStopMainStress1              = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdStopMainStress1'. --> lifetime is controlled by instance of this class
#if 0 // gib2hi: display slideshow is not working in G3G project as used interfaces are GM specific
      pCmdGetDisplaySlideshow          = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pCmdGetDisplaySlideshow'. --> lifetime is controlled by instance of this class
#endif
   } //lint !e438 Warning: last value assigned to variable 'pCmdSysOperationTime' not used

   setInitializationLevel(level);
   DIA_TR_INF("##### INITIALIZATION OF LEVEL %d DONE #####",(((tS16) level)-1));

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_FactoryPluginRunIn::tearDownObjects ( dia_enInitLevel level )
{
   dia_tclFnctTrace oTrace("dia_FactoryPluginRunIn::tearDownObjects");

   dia_LockScope mScopeLock(mSyncObj);

   if ( level == DIA_EN_INITLEVEL_3 || level == DIA_EN_INITLEVEL_ALL )
   {
      if ( mpEngine && (mpEngine->shutdown() != DIA_SUCCESS) ) return DIA_FAILED;
      OSAL_DELETE mpEngine;
      mpEngine = 0;

      // destroy all routine instances
      DIA_IMPL_LIST_REPOSITORY_TEAR_DOWN(dia_CommandInfoUDS,mCommandRep);
   }

   if ( getInitializationLevel() > DIA_EN_INITLEVEL_UNKNOWN )
   {
      setInitializationLevel((dia_enInitLevel) (((tS16) level) - 1));
      DIA_TR_INF("##### SHUTDOWN OF LEVEL %d DONE #####",(((tS16) level)-1));
   }

   return DIA_SUCCESS;
}

