/*!
 * \file       dia_FactoryPluginPDXFlashing.h
 *
 * \brief      Factory used to instantiate/shutdown the flashing engine
 *
 * \details    Factory used to instantiate/shutdown the flashing engine
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreFactory
 *
 * \copyright  (c) 2011-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__
#define __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

namespace dia {

class EngineFlash;
class EngineFlashConfiguration;


class FactoryPluginPDXFlashing
   : public dia_ObjectWithUID
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(FactoryPluginPDXFlashing);

public:
   //! setup (create objects,...)
   virtual tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( void );

   virtual EngineFlash* getEngine ( void ) { return mpEngine; }
   virtual EngineFlashConfiguration* getEngineConfiguration ( void ) { return mpConfig; }

   virtual void setStartMode ( bool mode ); // { mStartModeAutomatic = mode; }
   virtual void startFlashing ( void );

   static void addPDXFolder ( const std::string& pdxFolder );
   static const std::list<std::string>& getPDXContainers ( void );
   static void clearPDXContent ( void ) { mPDXFolderRep.clear(); mPDXFileRep.clear(); }

protected:
   //! class constructor
   FactoryPluginPDXFlashing ( void );
   //! class destructor
   virtual ~FactoryPluginPDXFlashing ( void );

   //! tear down all objects created by this class

   virtual tDiaResult makeEngineConfiguration ( const std::string& name );
   virtual tDiaResult makeEngine ( const std::string& name, EngineFlashConfiguration& config );

   static const std::list<std::string>& getPDXFolders ( void ) { return mPDXFolderRep; }
   static tDiaResult scanPDXContainers ( const std::string& folderName );

protected:
   EngineFlash* mpEngine;
   EngineFlashConfiguration* mpConfig;
   dia_Lock mSyncObj;
   bool mStartModeAutomatic;
   bool mIsSetupDone;
   static std::list<std::string> mPDXFolderRep;
   static std::list<std::string> mPDXFileRep;
};

}

dia::FactoryPluginPDXFlashing* getInstanceOfFactoryPluginPDXFlashing ( void );
void releaseInstanceOfFactoryPluginPDXFlashing ( void );

#endif /* __INCLUDED_DIA_FACTORY_PLUGIN_PDX_FLASHING__ */

