#ifndef __INCLUDED_DIA_FACTORY_PLUGIN_CORE__
#define __INCLUDED_DIA_FACTORY_PLUGIN_CORE__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#include "common/framework/factory/dia_FactoryPlugin.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include "common/framework/engine/dia_EngineManager.h"
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#include <common/framework/application/dia_ApplicationLock.h>

//class dia_Application;
class dia_CommandControllerPlugin;
//class dia_EngineManager;

class dia_FactoryPluginCore
   : public dia_FactoryPlugin
{
public:
   //! singleton constructor
   static dia_FactoryPluginCore* getInstance ( void );
   //! singleton destructor
   static void deleteInstance ( void );

   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level );
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level ) { return tearDownObjects(level); }

protected:
   //! class constructor
   dia_FactoryPluginCore ( void );
   //! class destructor
   virtual ~dia_FactoryPluginCore ( void );

   //! tear down all objects created by this class
   tDiaResult tearDownObjects ( dia_enInitLevel level=DIA_EN_INITLEVEL_ALL);

   void evaluateCMVariantCoding ( void ) const;

protected:
   //! pointer to the singleton
   static dia_FactoryPluginCore* mpInstance;
//   //! list of routine control objects
//   std::list<dia_IOCtrlSignal*> mSignalRep;
   //! pointer to the diagnosis application
   dia_Application*   mpApp;
   //! pointer to application Lock
   dia::ApplicationLock* mpAppLock;
   //! pointer to the ConfigManager
   dia_ConfigManager* mpConfigMgr;
   //! pointer to the application controller
   dia_AppController* mpAppCtrl;
   //! pointer to the engine manager
   dia_EngineManager* mpEngMgr;
   //! command controller plugins
   std::list<dia_CommandControllerPlugin*> mCmdCtrlPluginRep;

};

#endif
